import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/Alert/alert';
import accessibleStyles from '@patternfly/react-styles/css/utilities/Accessibility/accessibility';
import { AlertIcon } from './AlertIcon';
import { capitalize, getOUIAProps } from '../../helpers';
import { AlertContext } from './AlertContext';
export var AlertVariant;
(function (AlertVariant) {
    AlertVariant["success"] = "success";
    AlertVariant["danger"] = "danger";
    AlertVariant["warning"] = "warning";
    AlertVariant["info"] = "info";
    AlertVariant["default"] = "default";
})(AlertVariant || (AlertVariant = {}));
export const Alert = (_a) => {
    var { variant = AlertVariant.default, isInline = false, isLiveRegion = false, variantLabel = `${capitalize(variant)} alert:`, 'aria-label': ariaLabel = `${capitalize(variant)} Alert`, actionClose, actionLinks, title, children = '', className = '', ouiaId } = _a, props = __rest(_a, ["variant", "isInline", "isLiveRegion", "variantLabel", 'aria-label', "actionClose", "actionLinks", "title", "children", "className", "ouiaId"]);
    const getHeadingContent = (React.createElement(React.Fragment, null,
        React.createElement("span", { className: css(accessibleStyles.screenReader) }, variantLabel),
        title));
    const customClassName = css(styles.alert, isInline && styles.modifiers.inline, variant !== AlertVariant.default && styles.modifiers[variant], className);
    return (React.createElement("div", Object.assign({}, props, { className: customClassName, "aria-label": ariaLabel }, getOUIAProps('Alert', ouiaId), (isLiveRegion && {
        'aria-live': 'polite',
        'aria-atomic': 'false'
    })),
        React.createElement(AlertIcon, { variant: variant }),
        React.createElement("h4", { className: css(styles.alertTitle) }, getHeadingContent),
        actionClose && (React.createElement(AlertContext.Provider, { value: { title, variantLabel } },
            React.createElement("div", { className: css(styles.alertAction) }, actionClose))),
        children && React.createElement("div", { className: css(styles.alertDescription) }, children),
        actionLinks && React.createElement("div", { className: css(styles.alertActionGroup) }, actionLinks)));
};
//# sourceMappingURL=Alert.js.map