export { CapabilityRegistration as Registration } from '../models/plugin';
/**
 * Are we running headless, in electron, or in a browser?
 *
 */
export declare enum Media {
    Unknown = 0,
    Headless = 1,
    Electron = 2,
    Browser = 3
}
/** map from provider to credentials */
interface CredentialsMap {
    [key: string]: any;
}
/**
 * Update the media, e.g. to indicate that we are running in a browser
 * context versus an Electron context.
 *
 */
export declare const setMedia: (media: Media) => void;
/**
 * What is our presentation media?
 *
 */
export declare const getMedia: () => Media;
export declare const isHeadless: () => boolean;
export declare const inElectron: () => boolean;
export declare const inBrowser: () => boolean;
/**
 * Is Kui supported by a remote proxy?
 *
 */
export declare const hasProxy: () => boolean;
/**
 * Assert that Kui is supported by a remote proxy
 *
 */
export declare const assertHasProxy: () => void;
/**
 * Yes, we are running in a sandbox
 *
 */
export declare function assertInSandbox(): void;
/**
 * Are we running in a sandbox?
 *
 */
export declare function inSandbox(): boolean;
/**
 * Yes, we have valid credentials to interface with the given
 * provider
 *
 */
export declare const setHasAuth: (provider: string, creds: object) => void;
/**
 * Retrieve the auth model for the given provider
 *
 */
export declare const getAuth: (provider: string) => any;
/**
 * Retrieve the value for the given key for the auth model of the given provider
 *
 */
export declare const getAuthValue: (provider: string, key: string) => any;
/**
 * Return a map of all valid credentials
 *
 */
export declare const getValidCredentials: () => CredentialsMap;
/**
 * Inject the credentials map
 *
 */
export declare const setValidCredentials: (creds: CredentialsMap) => void;
/**
 * Do we have valid credentials to interface with the given provider?
 *
 */
export declare const hasAuth: (provider: string) => boolean;
/**
 * Do we have access to a local system?
 *
 */
export declare const hasLocalAccess: () => boolean;
/**
 * Assert that we have local access, even if the default behavior
 * would indicate otherwise
 *
 */
export declare const assertLocalAccess: () => void;
