import { Entity } from './entity';
import { Mode } from './mmr/types';
export interface Breadcrumb {
    label: string;
    command?: string;
}
/**
 * A `NavResponse` is a collection of `MultiModalResponse` with menu navigation
 *
 */
export declare type NavResponse = {
    apiVersion: 'kui-shell/v1';
    kind: 'NavResponse';
    menus: Menu[];
    links?: Link[];
    breadcrumbs?: Breadcrumb[];
};
export declare type Menu = Label & MenuItems;
declare type MenuItems = {
    items: Mode[];
};
declare type Label = {
    label: string;
};
declare type Command = {
    command: string;
};
declare type Href = {
    href: string;
};
export declare type Link = Label & (Command | Href);
export declare function isLinkWithCommand(link: Link): link is Label & Command;
export declare function isLinkWithHref(link: Link): link is Label & Href;
export declare function isLink(link: Link): link is Link;
export declare function isNavResponse(entity: Entity): entity is NavResponse;
export default NavResponse;
