import { Table } from '@kui-shell/core';
export declare function cpuFraction(str: string): number;
export declare function cpuShare(str: string): number;
export declare function memShare(str: string): number;
export declare function formatAsBytes(mem: number): string;
/** Turn e.g. 4041544Ki into 3947Mi */
export declare function reformatAsBytes(mem: string): string;
/** Fraction of two string-form memory figures */
export declare function fractionOfMemory(num: string, denom: string): string;
export declare function formatAsCpu(cpu: number): string;
export declare function parseAsTime(str: string): string;
export declare function fromSize(str: string): number;
/**
 * @return the sum of the attributes in the given column, interpreted
 * as times
 *
 */
export declare function sumTime(table: Table, attrIdx: number, backupAttrIdx?: number): number;
/**
 * @return the sum of the attributes in the given column, interpreted as sizes
 *
 */
export declare function sumSize(table: Table, attrIdx: number, backupAttrIdx?: number): number;
export declare function parseAsSize(str: string): string;
/** Rollup export */
declare const Parser: {
    fractionOfMemory: typeof fractionOfMemory;
    reformatAsBytes: typeof reformatAsBytes;
    formatAsBytes: typeof formatAsBytes;
    formatAsCpu: typeof formatAsCpu;
    cpuShare: typeof cpuShare;
    memShare: typeof memShare;
    cpuFraction: typeof cpuFraction;
};
export default Parser;
