/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import raw from './controller/raw';
import getProjects from './controller/oc/get/projects';
import delegates from './controller/kubectl/delegates';
import catchall from './controller/kubectl/catchall';
export default (registrar) => {
    delegates(registrar);
    getProjects(registrar);
    raw(registrar);
    catchall(registrar);
};
//# sourceMappingURL=plugin.js.map