"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

/*
 * Copyright 2019-20 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-core-support');
const usage = {
  command: 'confirm',
  strict: 'confirm',
  example: 'confirm [--asking <confirmation message>] <your-command-to-execute>',
  docs: 'Confirmation Modal',
  optional: [{
    name: '--asking',
    docs: strings('confirmationMessage')
  }],
  required: [{
    name: 'command',
    docs: strings('commandToBeExecuted')
  }]
};
/**
 * This plugin introduces the /confirm command
 *
 */

var _default = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  commandTree.listen('/confirm', ({
    tab,
    argvNoOptions,
    parsedOptions,
    execOptions,
    REPL
  }) => new Promise((resolve, reject) => {
    const asking = parsedOptions.asking || strings('areYouSure');
    const command = argvNoOptions[argvNoOptions.indexOf('confirm') + 1];
    const {
      execUUID
    } = execOptions;
    const requestChannel = `/kui-shell/Confirm/v1/tab/${(0, _core.getPrimaryTabId)(tab)}`;
    const responseChannel = `${requestChannel}/execUUID/${execUUID}/confirmed`;

    const onConfirm = ({
      confirmed
    }) => {
      if (!confirmed) {
        reject(strings('operationCancelled'));
      } else if (execOptions.type === _core.ExecType.Nested) {
        REPL.pexec(command, {
          tab
        }).then(resolve, reject);
      } else {
        REPL.qexec(command, undefined, undefined, {
          tab
        }).then(resolve, reject);
      }
    };

    _core.eventChannelUnsafe.once(responseChannel, onConfirm);

    _core.eventChannelUnsafe.emit(requestChannel, {
      command,
      asking,
      execUUID
    });
  }), {
    usage,
    incognito: ['popup']
  });
});

exports.default = _default;