import * as React from 'react';
import { Tab as KuiTab, ScalarResponse } from '@kui-shell/core';
interface Props {
    tab: KuiTab;
    response: ScalarResponse | Error;
    isPinned: boolean;
    onRender: (hasContent: boolean) => void;
}
interface State {
    catastrophicError: Error;
}
/**
 * Component that renders a "ScalarResponse", which is a command
 * response that doesn't require any particularly special
 * interpretation or visualization of the inner structure --- i.e. a
 * response that is suitable for rendering directly in the Terminal.
 *
 */
export default class Scalar extends React.PureComponent<Props, State> {
    constructor(props: Props);
    static getDerivedStateFromError(error: any): {
        catastrophicError: any;
    };
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    render(): {};
}
export {};
