import * as React from 'react';
import { Tab as KuiTab, ParsedOptions, MultiModalMode, MultiModalResponse, Button } from '@kui-shell/core';
import { BaseSidecar, Props, SidecarHistoryEntry } from './BaseSidecar';
import '../../../../web/css/static/ToolbarButton.scss';
/**
 * One history entry, which is a `MultiModalResponse`, further parsed
 * out into buttons and tabs, and a pointer to the `currentTabIndex`.
 *
 */
interface HistoryEntry extends SidecarHistoryEntry {
    currentTabIndex: number;
    buttons: Button[];
    tabs: Readonly<MultiModalMode[]>;
    response: Readonly<MultiModalResponse>;
    defaultMode: number;
}
export declare function getStateFromMMR(tab: KuiTab, response: MultiModalResponse, execUUID: string, argvNoOptions: string[], parsedOptions: ParsedOptions): HistoryEntry;
/**
 *
 * TopNavSidecar
 * -----------------------
 * | <TitleBar/>         |
 * -----------------------
 * | nameHash?           |
 * | name                |
 * |---------------------|
 * | Tab | Tab |  ...    | <Tab/> from here down
 * |---------------------|
 * | <Toolbar/>          |   <ToolbarContainer/> from here down
 * |---------------------|
 * | <KuiContent/>       |
 * |                     |
 * -----------------------
 *
 */
export default class TopNavSidecar extends BaseSidecar<MultiModalResponse, HistoryEntry> {
    static contextType: React.Context<import("../../Client/KuiConfiguration").default>;
    constructor(props: Props);
    /** Consult our History model for a match */
    protected lookupHistory(response: MultiModalResponse, argvNoOptions: string[], parsedOptions: ParsedOptions, cwd: string): number;
    /** @return a `HistoryEntry` for the given `Response` */
    protected getState(tab: KuiTab, response: MultiModalResponse, execUUID: any, argvNoOptions: string[], parsedOptions: ParsedOptions): HistoryEntry;
    protected headerBodyStyle(): {
        'flex-direction': string;
    };
    /** return the pretty name or unadulterated name from the response */
    private prettyName;
    /** display the unadulterated name from the response as sidecar header */
    private namePart;
    /** Tell the world that we have changed the focused mode */
    private broadcastFocusChange;
    private tabs;
    protected bodyContent(idx: number): JSX.Element;
    private tabContent;
    /** Return a collection of badge elements */
    private badges;
    private header;
    private kindBreadcrumb;
    /** show name as breadcrumb when not showing context as hero text in sidecar header  */
    private nameBreadcrumb;
    private versionBreadcrumb;
    private nameHashBreadcrumb;
    private namespaceBreadcrumb;
    render(): JSX.Element;
}
export {};
