import { ScalarResponse } from '@kui-shell/core';
declare const enum BlockState {
    Active = "repl-active",
    Cancelled = "cancelled",
    Empty = "empty",
    Error = "error",
    Processing = "processing",
    ValidResponse = "valid-response"
}
/** Traits that Blocks might have */
declare type WithCWD = {
    cwd: string;
};
declare type WithUUID = {
    execUUID: string;
};
declare type WithCommand = {
    command: string;
} & WithCWD;
declare type WithStartTime = {
    startTime: Date;
};
declare type WithState<S extends BlockState> = {
    state: S;
};
declare type WithResponse<R extends ScalarResponse> = {
    response: R;
} & WithStartTime;
declare type WithValue = {
    value: string;
};
declare type withPin = {
    isPinned: boolean;
};
declare type WithAnnouncement = {
    isAnnouncement: boolean;
};
/** The canonical types of Blocks, which mix up the Traits as needed */
declare type ActiveBlock = WithState<BlockState.Active> & WithCWD & Partial<WithValue>;
export declare type AnnouncementBlock = WithState<BlockState.ValidResponse> & WithResponse<ScalarResponse> & WithCWD & WithAnnouncement;
declare type EmptyBlock = WithState<BlockState.Empty> & WithCWD;
declare type ErrorBlock = WithState<BlockState.Error> & WithCommand & WithResponse<Error> & WithUUID;
declare type OkBlock = WithState<BlockState.ValidResponse> & WithCommand & WithResponse<ScalarResponse> & WithUUID;
export declare type ProcessingBlock = WithState<BlockState.Processing> & WithCommand & WithUUID & WithStartTime;
declare type CancelledBlock = WithState<BlockState.Cancelled> & WithCWD & WithCommand & WithUUID & WithStartTime;
/** FinishedBlocks are either ok, error, or cancelled */
export declare type FinishedBlock = OkBlock | ErrorBlock | CancelledBlock | EmptyBlock;
export declare type BlockModel = (ProcessingBlock | FinishedBlock | CancelledBlock | ActiveBlock | AnnouncementBlock) & Partial<withPin>;
export default BlockModel;
export declare function isError(response: ScalarResponse): response is Error;
export declare function isProcessing(block: BlockModel): block is ProcessingBlock;
export declare function isActive(block: BlockModel): block is ActiveBlock;
export declare function isCancelled(block: BlockModel): block is CancelledBlock;
export declare function isEmpty(block: BlockModel): block is EmptyBlock;
export declare function isOk(block: BlockModel): block is OkBlock;
export declare function isOops(block: BlockModel): block is ErrorBlock;
export declare function isFinished(block: BlockModel): block is FinishedBlock;
export declare function hasCommand(block: BlockModel & Partial<WithCommand>): block is BlockModel & Required<WithCommand>;
export declare function isAnnouncement(block: BlockModel): block is AnnouncementBlock;
export declare function hasUUID(block: BlockModel & Partial<WithUUID>): block is BlockModel & Required<WithUUID>;
export declare function hasValue(block: BlockModel): block is BlockModel & Required<WithValue>;
/** Transform to Active */
export declare function Active(initialValue?: string): ActiveBlock;
/** Transform to AnnouncementBlock */
export declare function Announcement(response: ScalarResponse): AnnouncementBlock;
/** Transform to Processing */
export declare function Processing(block: BlockModel, command: string, execUUID: string): ProcessingBlock;
/** Transform to Empty */
export declare function Empty(block: BlockModel): EmptyBlock;
/** Transform to Cancelled */
export declare function Cancelled(block: BlockModel): CancelledBlock | EmptyBlock;
/** Transform to Finished */
export declare function Finished(block: ProcessingBlock, response: ScalarResponse, cancelled: boolean): FinishedBlock;
