/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import InlineCheckbox from '../InlineCheckbox';
import cx from 'classnames';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var TableSelectAll = function TableSelectAll(_ref) {
  var ariaLabel = _ref.ariaLabel,
      checked = _ref.checked,
      id = _ref.id,
      indeterminate = _ref.indeterminate,
      name = _ref.name,
      onSelect = _ref.onSelect,
      disabled = _ref.disabled,
      className = _ref.className;
  return React.createElement("th", {
    scope: "col",
    className: cx("".concat(prefix, "--table-column-checkbox"), className)
  }, React.createElement(InlineCheckbox, {
    ariaLabel: ariaLabel,
    checked: checked,
    id: id,
    indeterminate: indeterminate,
    name: name,
    onClick: onSelect,
    disabled: disabled
  }));
};

TableSelectAll.propTypes = {
  /**
   * Specify the aria label for the underlying input control
   */
  ariaLabel: PropTypes.string.isRequired,

  /**
   * Specify whether all items are selected, or not
   */
  checked: PropTypes.bool.isRequired,

  /**
   * Provide an `id` for the underlying input control
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify whether the selection only has a subset of all items
   */
  indeterminate: PropTypes.bool,

  /**
   * Provide a `name` for the underlying input control
   */
  name: PropTypes.string.isRequired,

  /**
   * Provide a handler to listen to when a user initiates a selection request
   */
  onSelect: PropTypes.func.isRequired,

  /**
   * The CSS class names of the cell that wraps the underlying input control
   */
  className: PropTypes.string
};
TableSelectAll.defaultProps = {
  ariaLabel: 'Select all rows in the table'
};
export default TableSelectAll;