"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _ComposedModal = _interopRequireWildcard(require("../ComposedModal"));

var _Button = _interopRequireDefault(require("../Button"));

var _carbonComponents = require("carbon-components");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
var sizes = {
  Default: '',
  'Extra small (xs)': 'xs',
  'Small (sm)': 'sm',
  'Large (lg)': 'lg'
};
var props = {
  composedModal: function composedModal() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        titleOnly = _ref.titleOnly;

    return {
      open: (0, _addonKnobs.boolean)('Open (open in <ComposedModal>)', true),
      onKeyDown: (0, _addonActions.action)('onKeyDown'),
      danger: (0, _addonKnobs.boolean)('Danger mode (danger)', false),
      selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', '[data-modal-primary-focus]'),
      size: (0, _addonKnobs.select)('Size (size)', sizes, titleOnly ? 'sm' : '')
    };
  },
  modalHeader: function modalHeader() {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        titleOnly = _ref2.titleOnly;

    return {
      label: (0, _addonKnobs.text)('Optional Label (label in <ModalHeader>)', 'Optional Label'),
      title: (0, _addonKnobs.text)('Optional title (title in <ModalHeader>)', titleOnly ? "\n      Passive modal title as the message. Should be direct and 3 lines or less.\n    ".trim() : 'Example'),
      iconDescription: (0, _addonKnobs.text)('Close icon description (iconDescription in <ModalHeader>)', 'Close'),
      buttonOnClick: (0, _addonActions.action)('buttonOnClick')
    };
  },
  modalBody: function modalBody() {
    return {
      hasScrollingContent: (0, _addonKnobs.boolean)('Modal contains scrollable content (hasScrollingContent)', true),
      'aria-label': (0, _addonKnobs.text)('ARIA label for content', 'Example modal content')
    };
  },
  modalFooter: function modalFooter() {
    return {
      primaryButtonText: (0, _addonKnobs.text)('Primary button text (primaryButtonText in <ModalFooter>)', 'Save'),
      primaryButtonDisabled: (0, _addonKnobs.boolean)('Primary button disabled (primaryButtonDisabled in <ModalFooter>)', false),
      secondaryButtonText: (0, _addonKnobs.text)('Secondary button text (secondaryButtonText in <ModalFooter>)', ''),
      onRequestClose: (0, _addonActions.action)('onRequestClose'),
      onRequestSubmit: (0, _addonActions.action)('onRequestSubmit')
    };
  }
};

var scrollingContent = _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("h3", null, "Lorem ipsum"), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '));

(0, _react2.storiesOf)('ComposedModal', module).addDecorator(_addonKnobs.withKnobs).add('Using Header / Footer Props', function () {
  var _props$composedModal = props.composedModal(),
      size = _props$composedModal.size,
      rest = _objectWithoutProperties(_props$composedModal, ["size"]);

  var _props$modalBody = props.modalBody(),
      hasScrollingContent = _props$modalBody.hasScrollingContent,
      bodyProps = _objectWithoutProperties(_props$modalBody, ["hasScrollingContent"]);

  return _react.default.createElement(_ComposedModal.default, _extends({}, rest, {
    size: size || undefined
  }), _react.default.createElement(_ComposedModal.ModalHeader, props.modalHeader()), _react.default.createElement(_ComposedModal.ModalBody, _extends({}, bodyProps, {
    "aria-label": hasScrollingContent ? 'Modal content' : undefined
  }), _react.default.createElement("p", {
    className: "".concat(prefix, "--modal-content__text")
  }, "Please see ModalWrapper for more examples and demo of the functionality."), hasScrollingContent && scrollingContent), _react.default.createElement(_ComposedModal.ModalFooter, props.modalFooter()));
}, {
  info: {
    text: "\n            Composed Modal allows you to create your own modal with just the parts you need. The ComposedModal element provides the state management for open/close, as well as passes the ModalHeader a prop to close the modal (with the close button).\n\n            The interior components - ModalHeader / ModalBody / ModalFooter - are all container elements that will render any children you add in, wrapped in the appropriate CSS classes.\n\n            The Modal Header / Modal Footer come with some built in props to let you accelerate towards standard Carbon modal UI. If there are customizations you need to do, see the next example of just using the interior components as containers.\n          "
  }
}).add('Using child nodes', function () {
  var _props$composedModal2 = props.composedModal(),
      size = _props$composedModal2.size,
      rest = _objectWithoutProperties(_props$composedModal2, ["size"]);

  var _props$modalBody2 = props.modalBody(),
      hasScrollingContent = _props$modalBody2.hasScrollingContent,
      bodyProps = _objectWithoutProperties(_props$modalBody2, ["hasScrollingContent"]);

  return _react.default.createElement(_ComposedModal.default, _extends({}, rest, {
    size: size || undefined
  }), _react.default.createElement(_ComposedModal.ModalHeader, props.modalHeader(), _react.default.createElement("h1", null, "Testing")), _react.default.createElement(_ComposedModal.ModalBody, _extends({}, bodyProps, {
    "aria-label": hasScrollingContent ? 'Modal content' : undefined
  }), _react.default.createElement("p", null, "Please see ModalWrapper for more examples and demo of the functionality."), hasScrollingContent && scrollingContent), _react.default.createElement(_ComposedModal.ModalFooter, null, _react.default.createElement(_Button.default, {
    kind: "secondary"
  }, "Cancel"), _react.default.createElement(_Button.default, {
    kind: props.composedModal().danger ? 'danger' : 'primary'
  }, "Save")));
}, {
  info: {
    text: "\n            Alternatively, you can just use the Modal components as wrapper elements and figure the children out yourself. We do suggest for the header you utilize the built in props for label and title though, for the footer it's mostly a composed element so creating the two buttons yourself (using the Button component) is probably the most straight-forward pattern.\n          "
  }
}).add('Title only', function () {
  var _props$composedModal3 = props.composedModal({
    titleOnly: true
  }),
      size = _props$composedModal3.size,
      rest = _objectWithoutProperties(_props$composedModal3, ["size"]);

  return _react.default.createElement(_ComposedModal.default, _extends({}, rest, {
    size: size || undefined
  }), _react.default.createElement(_ComposedModal.ModalHeader, props.modalHeader({
    titleOnly: true
  })), _react.default.createElement(_ComposedModal.ModalBody, null), _react.default.createElement(_ComposedModal.ModalFooter, props.modalFooter()));
}, {
  info: {
    text: "\n          In \"small\" and \"xs\" modals size, the title is allowed to span multiple lines and be used for the main message.\n          It should be less than 3 lines of text. If more room is required then use the standard body copy format.\n        "
  }
}).add('Example usage with trigger button', function () {
  var ComposedModalExample =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(ComposedModalExample, _React$Component);

    function ComposedModalExample() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, ComposedModalExample);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ComposedModalExample)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {
        open: false
      });

      _defineProperty(_assertThisInitialized(_this), "toggleModal", function (open) {
        return _this.setState({
          open: open
        });
      });

      return _this;
    }

    _createClass(ComposedModalExample, [{
      key: "render",
      value: function render() {
        var _this2 = this;

        var open = this.state.open;

        var _props$composedModal4 = props.composedModal(),
            size = _props$composedModal4.size,
            rest = _objectWithoutProperties(_props$composedModal4, ["size"]);

        var _props$modalBody3 = props.modalBody(),
            hasScrollingContent = _props$modalBody3.hasScrollingContent,
            bodyProps = _objectWithoutProperties(_props$modalBody3, ["hasScrollingContent"]);

        return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_Button.default, {
          onClick: function onClick() {
            return _this2.toggleModal(true);
          }
        }, "Launch composed modal"), _react.default.createElement(_ComposedModal.default, _extends({}, rest, {
          open: open,
          size: size || undefined,
          onClose: function onClose() {
            return _this2.toggleModal(false);
          }
        }), _react.default.createElement(_ComposedModal.ModalHeader, props.modalHeader()), _react.default.createElement(_ComposedModal.ModalBody, _extends({}, bodyProps, {
          "aria-label": hasScrollingContent ? 'Modal content' : undefined
        }), _react.default.createElement("p", {
          className: "".concat(prefix, "--modal-content__text")
        }, "Please see ModalWrapper for more examples and demo of the functionality."), hasScrollingContent && scrollingContent), _react.default.createElement(_ComposedModal.ModalFooter, props.modalFooter())));
      }
    }]);

    return ComposedModalExample;
  }(_react.default.Component);

  return _react.default.createElement(ComposedModalExample, null);
}, {
  info: {
    text: "\n            An example ComposedModal with a trigger button\n          "
  }
});