"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
var getInstanceId = (0, _setupGetInstanceId.default)();

function Loading(_ref) {
  var _cx, _cx2;

  var active = _ref.active,
      customClassName = _ref.className,
      withOverlay = _ref.withOverlay,
      small = _ref.small,
      description = _ref.description,
      rest = _objectWithoutProperties(_ref, ["active", "className", "withOverlay", "small", "description"]);

  var _useRef = (0, _react.useRef)(getInstanceId()),
      instanceId = _useRef.current;

  var loadingClassName = (0, _classnames.default)(customClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--loading"), true), _defineProperty(_cx, "".concat(prefix, "--loading--small"), small), _defineProperty(_cx, "".concat(prefix, "--loading--stop"), !active), _cx));
  var overlayClassName = (0, _classnames.default)((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--loading-overlay"), true), _defineProperty(_cx2, "".concat(prefix, "--loading-overlay--stop"), !active), _cx2));
  var loadingId = "loading-id-".concat(instanceId);
  var spinnerRadius = small ? '26.8125' : '37.5';

  var loading = _react.default.createElement("div", _extends({}, rest, {
    "aria-atomic": "true",
    "aria-labelledby": loadingId,
    "aria-live": active ? 'assertive' : 'off',
    className: loadingClassName
  }), _react.default.createElement("label", {
    id: loadingId,
    className: "".concat(prefix, "--visually-hidden")
  }, description), _react.default.createElement("svg", {
    className: "".concat(prefix, "--loading__svg"),
    viewBox: "-75 -75 150 150"
  }, _react.default.createElement("title", null, description), small ? _react.default.createElement("circle", {
    className: "".concat(prefix, "--loading__background"),
    cx: "0",
    cy: "0",
    r: spinnerRadius
  }) : null, _react.default.createElement("circle", {
    className: "".concat(prefix, "--loading__stroke"),
    cx: "0",
    cy: "0",
    r: spinnerRadius
  })));

  return withOverlay ? _react.default.createElement("div", {
    className: overlayClassName
  }, loading) : loading;
}

Loading.propTypes = {
  /**
   * Specify whether you want the loading indicator to be spinning or not
   */
  active: _propTypes.default.bool,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether you want the loader to be applied with an overlay
   */
  withOverlay: _propTypes.default.bool,

  /**
   * Specify whether you would like the small variant of <Loading>
   */
  small: _propTypes.default.bool,

  /**
   * Specify an description that would be used to best describe the loading state
   */
  description: _propTypes.default.string
};
Loading.defaultProps = {
  active: true,
  withOverlay: true,
  small: false,
  description: 'Active loading indicator'
};
var _default = Loading;
exports.default = _default;