import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Select/select';
import formStyles from '@patternfly/react-styles/css/components/Form/form';
import { css } from '@patternfly/react-styles';
import { SelectOption } from './SelectOption';
import { SelectConsumer, SelectVariant } from './selectConstants';
import { FocusTrap } from '../../helpers';
export class SelectMenu extends React.Component {
    extendChildren() {
        const { children, isGrouped } = this.props;
        const childrenArray = children;
        if (isGrouped) {
            let index = 0;
            return React.Children.map(childrenArray, (group) => React.cloneElement(group, {
                titleId: group.props.label.replace(/\W/g, '-'),
                children: group.props.children.map((option) => this.cloneOption(option, index++))
            }));
        }
        return React.Children.map(childrenArray, (child, index) => this.cloneOption(child, index));
    }
    cloneOption(child, index) {
        const { selected, sendRef, keyHandler } = this.props;
        const isSelected = selected && selected.constructor === Array
            ? selected && (Array.isArray(selected) && selected.includes(child.props.value))
            : selected === child.props.value;
        return React.cloneElement(child, {
            id: `${child.props.value ? child.props.value.toString() : ''}-${index}`,
            isSelected,
            sendRef,
            keyHandler,
            index
        });
    }
    extendCheckboxChildren(children) {
        const { isGrouped, checked, sendRef, keyHandler, hasInlineFilter } = this.props;
        let index = hasInlineFilter ? 1 : 0;
        if (isGrouped) {
            return React.Children.map(children, (group) => {
                if (group.type === SelectOption) {
                    return group;
                }
                return React.cloneElement(group, {
                    titleId: group.props.label.replace(/\W/g, '-'),
                    children: (React.createElement("fieldset", { "aria-labelledby": group.props.label.replace(/\W/g, '-'), className: css(styles.selectMenuFieldset) }, group.props.children.map((option) => React.cloneElement(option, {
                        isChecked: checked && checked.includes(option.props.value),
                        sendRef,
                        keyHandler,
                        index: index++
                    }))))
                });
            });
        }
        return React.Children.map(children, (child) => React.cloneElement(child, {
            isChecked: checked && checked.includes(child.props.value),
            sendRef,
            keyHandler,
            index: index++
        }));
    }
    render() {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { children, isCustomContent, className, isExpanded, openedOnEnter, selected, checked, isGrouped, sendRef, keyHandler, maxHeight, noResultsFoundText, createText, 'aria-label': ariaLabel, 'aria-labelledby': ariaLabelledBy, hasInlineFilter } = _a, props = __rest(_a, ["children", "isCustomContent", "className", "isExpanded", "openedOnEnter", "selected", "checked", "isGrouped", "sendRef", "keyHandler", "maxHeight", "noResultsFoundText", "createText", 'aria-label', 'aria-labelledby', "hasInlineFilter"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        return (React.createElement(SelectConsumer, null, ({ variant }) => (React.createElement(React.Fragment, null,
            isCustomContent && (React.createElement("div", Object.assign({ className: css(styles.selectMenu, className) }, (maxHeight && { style: { maxHeight, overflow: 'auto' } }), props), children)),
            variant !== SelectVariant.checkbox && !isCustomContent && (React.createElement("ul", Object.assign({ className: css(styles.selectMenu, className), role: "listbox" }, (maxHeight && { style: { maxHeight, overflow: 'auto' } }), props), this.extendChildren())),
            variant === SelectVariant.checkbox && !isCustomContent && React.Children.count(children) > 0 && (React.createElement(FocusTrap, { focusTrapOptions: { clickOutsideDeactivates: true } },
                React.createElement("div", Object.assign({ className: css(styles.selectMenu, className) }, (maxHeight && { style: { maxHeight, overflow: 'auto' } })),
                    React.createElement("fieldset", Object.assign({}, props, { "aria-label": ariaLabel, "aria-labelledby": (!ariaLabel && ariaLabelledBy) || null, className: css(formStyles.formFieldset) }),
                        hasInlineFilter && [
                            children.shift(),
                            ...this.extendCheckboxChildren(children)
                        ],
                        !hasInlineFilter && this.extendCheckboxChildren(children))))),
            variant === SelectVariant.checkbox && !isCustomContent && React.Children.count(children) === 0 && (React.createElement("div", Object.assign({ className: css(styles.selectMenu, className) }, (maxHeight && { style: { maxHeight, overflow: 'auto' } })),
                React.createElement("fieldset", { className: css(styles.selectMenuFieldset) })))))));
    }
}
SelectMenu.defaultProps = {
    className: '',
    isExpanded: false,
    isGrouped: false,
    openedOnEnter: false,
    selected: '',
    maxHeight: '',
    sendRef: () => { },
    keyHandler: () => { },
    isCustomContent: false,
    hasInlineFilter: false
};
//# sourceMappingURL=SelectMenu.js.map