declare const _default: () => {
    /**
     * Retrieve an entry from localStorage. The LocalStorage API
     * says to return null if there's no such key, to distinguish
     * from the something being of value `undefined`.
     *
     */
    getItem: (key: string) => string;
    /**
     * Update an entry in localStorage
     *
     */
    setItem: (key: string, val: string) => string;
    /**
     * Remove an entry from localStorage
     *
     */
    removeItem: (key: string) => string;
};
/**
 * This module implements a simple localStorage layer for headless mode
 *
 */
export default _default;
