import { Table, Row } from '../webapp/models/table';
import { ToolbarText } from '../webapp/views/toolbar-text';
import { UsageModel } from '../core/usage-error';
import { MultiModalResponse } from './mmr/types';
import { NavResponse } from './NavResponse';
import RadioTable from './RadioTable';
import Presentation from '../webapp/views/presentation';
import { ReactNode } from 'react';
export interface MessageBearingEntity {
    message: string;
}
export declare function isMessageBearingEntity(entity: Entity | MessageBearingEntity): entity is MessageBearingEntity;
/**
 * The name part of a metadata bearing resource.
 *
 */
export interface MetadataNamedResource {
    kind?: string;
    metadata?: {
        name: string;
        namespace?: string;
        generation?: string;
        creationTimestamp?: string;
    };
}
/**
 * A minimal subset of a kubernetes-like resource specification that
 * identifies a resource
 *
 */
export interface MetadataBearing<Content = void> extends MetadataNamedResource {
    apiVersion?: string;
    /** optional designation of resource version */
    version?: string;
    /** name hash, e.g. the hash part of auto-generated names, or an openwhisk activation id */
    prettyName?: string;
    nameHash?: string;
    /** family of onclick handlers */
    onclick?: {
        kind?: string;
        name?: string;
        nameHash?: string;
        namespace?: string;
    };
    content?: Content;
    contentType?: string;
    toolbarText?: ToolbarText;
    presentation?: Presentation;
}
export declare type MetadataBearingWithContent<T extends any = any> = MetadataBearing<T>;
export declare function isMetadataBearing(spec: MetadataBearing | Entity): spec is MetadataBearing;
export interface WithDisplayName extends MetadataBearing {
    spec: {
        displayName: string;
    };
}
export declare function hasDisplayName(resource: MetadataBearing): resource is WithDisplayName;
/**
 * Entity with a "resource" field that is MetadataBearing
 *
 */
export interface MetadataBearingByReference<Content = void> extends MetadataBearing<Content> {
    resource: MetadataBearing<Content>;
}
export declare type MetadataBearingByReferenceWithContent<T extends any = any> = MetadataBearingByReference<T>;
export declare function isMetadataBearingByReference<T extends MetadataBearingByReference>(spec: MetadataBearing | Entity | MetadataBearingWithContent | T): spec is T;
/**
 * A mostly scalar entity
 *
 */
export declare type SimpleEntity = boolean | string | number | HTMLElement | /* MessageBearingEntity | */ Error | MarkdownResponse | ReactResponse;
declare type MarkdownResponse = {
    content: string;
    contentType: 'text/markdown';
};
export declare function isMarkdownResponse(entity: Entity): entity is MarkdownResponse;
export declare type ReactResponse = {
    react: ReactNode;
};
export declare function isReactResponse(entity: Entity): entity is ReactResponse;
/**
 * The plugin returns a mix of types; e.g. `helm status` returns
 * [string, Table, string], where the status `Table` is sandwiched by
 * preface and trailing `string` messages
 *
 */
export declare type MixedResponsePart = string | Table | HTMLElement;
export declare type MixedResponse = MixedResponsePart[];
export declare function isMixedResponse(response: Entity): response is MixedResponse;
/**
 * This allows commands to pass through raw responses from their backend
 *
 */
export declare type RawContent = any;
export interface RawResponse<Content extends RawContent> {
    mode: 'raw';
    content: Content;
}
export declare function isRawResponse<Content extends RawContent>(entity: Entity<Content>): entity is RawResponse<Content>;
/**
 * This type covers all responses with no complex internal structure
 * that views may wish to interpret into fancier views.
 *
 */
export declare type ScalarResponse<RowType extends Row = Row> = SimpleEntity | Table<RowType> | MixedResponse;
export declare type ViewableResponse = MultiModalResponse | NavResponse | RadioTable;
export declare type StructuredResponse<Content = void, SomeSortOfResource extends MetadataBearing<Content> = MetadataBearing<Content>> = ViewableResponse | UsageModel | SomeSortOfResource | RawResponse<Content> | SomeSortOfResource[];
/**
 * A potentially more complex entity with a "spec"
 *
 */
export declare type Entity<Content = void, RowType extends Row = Row, SomeSortOfResource extends MetadataBearing<Content> = MetadataBearing<Content>> = ScalarResponse | StructuredResponse<Content, SomeSortOfResource>;
export {};
