declare type FilterFunction = (line: HistoryLine) => boolean;
export interface HistoryLine {
    entityType?: string;
    verb?: string;
    response?: any;
    raw?: string;
}
export declare class HistoryModel {
    private _lines;
    private _cursor;
    constructor();
    /** return the given line of history */
    line(idx: number): HistoryLine;
    slice(start: number, end: number): HistoryLine[];
    get cursor(): number;
    /** change the cursor, protecting against under- and overflow */
    private guardedChange;
    /**
     * Clear out all history
     *
     */
    wipe(): boolean;
    /** add a line of repl history */
    add(line: HistoryLine): number;
    /** update a line of repl history -- for async operations */
    update(cursor: number, updateFn: (line: HistoryLine) => void): void;
    lineByIncr(incr: number): HistoryLine;
    /** go back one entry */
    previous(): HistoryLine;
    /** go forward one entry */
    next(): HistoryLine;
    /** return to the oldest entry */
    first(): HistoryLine;
    /** return to the newest entry */
    last(): HistoryLine;
    /**
     * Search the history model
     *
     * @param filter a search string, search regexp, or search function
     * @param startIdx if undefined or negative, start from the end, otherwise,
     * search backwards from the given index
     *
     */
    findIndex(filter: string | RegExp | FilterFunction, startIdx?: number): number;
    /**
     * Search the history model
     *
     * @param filter a search string, search regexp, or search function
     *
     */
    find(filter: FilterFunction): HistoryLine;
}
export declare const History: HistoryModel;
export default History;
