import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import orderBy from 'lodash/orderBy';
import { Data } from 'victory-core';
import { VictoryPie } from 'victory-pie';
import { ChartContainer } from '../ChartContainer';
import { ChartDonut } from '../ChartDonut';
import { ChartCommonStyles, ChartDonutUtilizationStyles } from '../ChartTheme';
import { getDonutUtilizationTheme } from '../ChartUtils';
export var ChartDonutUtilizationLabelPosition;
(function (ChartDonutUtilizationLabelPosition) {
    ChartDonutUtilizationLabelPosition["centroid"] = "centroid";
    ChartDonutUtilizationLabelPosition["endAngle"] = "endAngle";
    ChartDonutUtilizationLabelPosition["startAngle"] = "startAngle";
})(ChartDonutUtilizationLabelPosition || (ChartDonutUtilizationLabelPosition = {}));
export var ChartDonutUtilizationLegendOrientation;
(function (ChartDonutUtilizationLegendOrientation) {
    ChartDonutUtilizationLegendOrientation["horizontal"] = "horizontal";
    ChartDonutUtilizationLegendOrientation["vertical"] = "vertical";
})(ChartDonutUtilizationLegendOrientation || (ChartDonutUtilizationLegendOrientation = {}));
export var ChartDonutUtilizationLegendPosition;
(function (ChartDonutUtilizationLegendPosition) {
    ChartDonutUtilizationLegendPosition["bottom"] = "bottom";
    ChartDonutUtilizationLegendPosition["right"] = "right";
})(ChartDonutUtilizationLegendPosition || (ChartDonutUtilizationLegendPosition = {}));
export var ChartDonutUtilizationSortOrder;
(function (ChartDonutUtilizationSortOrder) {
    ChartDonutUtilizationSortOrder["ascending"] = "ascending";
    ChartDonutUtilizationSortOrder["descending"] = "descending";
})(ChartDonutUtilizationSortOrder || (ChartDonutUtilizationSortOrder = {}));
export var ChartDonutUtilizationSubTitlePosition;
(function (ChartDonutUtilizationSubTitlePosition) {
    ChartDonutUtilizationSubTitlePosition["bottom"] = "bottom";
    ChartDonutUtilizationSubTitlePosition["center"] = "center";
    ChartDonutUtilizationSubTitlePosition["right"] = "right";
})(ChartDonutUtilizationSubTitlePosition || (ChartDonutUtilizationSubTitlePosition = {}));
export const ChartDonutUtilization = (_a) => {
    var { allowTooltip = true, ariaDesc, ariaTitle, containerComponent = React.createElement(ChartContainer, null), data, invert = false, legendPosition = ChartCommonStyles.legend.position, padding, showStatic = true, standalone = true, themeColor, themeVariant, thresholds, x, y, 
    // destructure last
    theme = getDonutUtilizationTheme(themeColor, themeVariant), height = theme.pie.height, width = theme.pie.width } = _a, rest = __rest(_a, ["allowTooltip", "ariaDesc", "ariaTitle", "containerComponent", "data", "invert", "legendPosition", "padding", "showStatic", "standalone", "themeColor", "themeVariant", "thresholds", "x", "y", "theme", "height", "width"]);
    // Returns computed data representing pie chart slices
    const getComputedData = () => {
        const datum = getData();
        const computedData = [{ x: datum[0]._x, y: datum[0]._y || 0 }];
        if (showStatic) {
            computedData.push({ y: datum[0]._x ? Math.abs(100 - datum[0]._y) : 100 });
        }
        return computedData;
    };
    const getData = () => {
        const datum = [Object.assign({}, data)];
        return Data.formatData(datum, Object.assign({ x, y }, rest), ['x', 'y']).sort((a, b) => a._y - b._y);
    };
    // Returns thresholds with default color scale
    const getDonutThresholds = () => {
        const result = [];
        if (thresholds) {
            // Ensure thresholds are in sorted order
            const sThresholds = orderBy(thresholds, 'value', invert ? 'desc' : 'asc');
            const numColors = ChartDonutUtilizationStyles.thresholds.colorScale.length;
            for (let i = 0; i < sThresholds.length; i++) {
                result.push({
                    color: sThresholds[i].color
                        ? sThresholds[i].color
                        : ChartDonutUtilizationStyles.thresholds.colorScale[i % numColors],
                    value: sThresholds[i].value
                });
            }
        }
        return result;
    };
    // Returns theme based on threshold and current value
    const getThresholdTheme = () => {
        const newTheme = Object.assign({}, theme);
        if (data) {
            const datum = getData();
            const donutThresholds = getDonutThresholds();
            const mergeThemeProps = (i) => {
                // Merge just the first color of dynamic (blue, green, etc.) with static (gray) for expected colorScale
                if (newTheme.pie.colorScale instanceof Array) {
                    newTheme.pie.colorScale[0] = donutThresholds[i].color;
                }
                else {
                    newTheme.pie.colorScale = donutThresholds[i].color;
                }
                if (newTheme.legend.colorScale instanceof Array) {
                    newTheme.legend.colorScale[0] = donutThresholds[i].color;
                }
                else {
                    newTheme.legend.colorScale = donutThresholds[i].color;
                }
            };
            for (let i = 0; i < donutThresholds.length; i++) {
                if (invert) {
                    if (datum[0]._y <= donutThresholds[i].value) {
                        mergeThemeProps(i);
                    }
                }
                else {
                    if (datum[0]._y >= donutThresholds[i].value) {
                        mergeThemeProps(i);
                    }
                }
            }
        }
        return newTheme;
    };
    // Dynamic donut chart
    const chart = (React.createElement(ChartDonut, Object.assign({ allowTooltip: allowTooltip, data: getComputedData(), height: height, key: "pf-chart-donut-utilization", legendPosition: legendPosition, padding: padding, standalone: false, theme: getThresholdTheme(), width: width }, rest)));
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ desc: ariaDesc, height, title: ariaTitle, width,
        theme }, containerComponent.props), [chart]);
    return standalone ? React.createElement(React.Fragment, null, container) : React.createElement(React.Fragment, null, chart);
};
ChartDonutUtilization.displayName = 'ChartDonutUtilization';
// Note: VictoryPie.role must be hoisted
hoistNonReactStatics(ChartDonutUtilization, VictoryPie);
//# sourceMappingURL=ChartDonutUtilization.js.map