import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryStack } from 'victory-stack';
import { ChartContainer } from '../ChartContainer';
import { getClassName, getTheme } from '../ChartUtils';
export const ChartStack = (_a) => {
    var { ariaDesc, ariaTitle, children, containerComponent = React.createElement(ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["ariaDesc", "ariaTitle", "children", "containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign(Object.assign({ desc: ariaDesc, title: ariaTitle, theme }, containerComponent.props), { className: getClassName({ className: containerComponent.props.className }) // Override VictoryContainer class name
     }));
    // Note: containerComponent is required for theme
    return (React.createElement(VictoryStack, Object.assign({ containerComponent: container, theme: theme }, rest), children));
};
ChartStack.displayName = 'ChartStack';
// Note: VictoryStack.getChildren & VictoryStack.role must be hoisted
hoistNonReactStatics(ChartStack, VictoryStack);
//# sourceMappingURL=ChartStack.js.map