/* eslint-disable camelcase */
import chart_global_FontFamily from "@patternfly/react-tokens/dist/esm/chart_global_FontFamily";
import chart_global_letter_spacing from "@patternfly/react-tokens/dist/esm/chart_global_letter_spacing";
import chart_global_FontSize_sm from "@patternfly/react-tokens/dist/esm/chart_global_FontSize_sm";
import chart_global_label_Padding from "@patternfly/react-tokens/dist/esm/chart_global_label_Padding";
import chart_global_label_stroke from "@patternfly/react-tokens/dist/esm/chart_global_label_stroke";
import chart_global_label_text_anchor from "@patternfly/react-tokens/dist/esm/chart_global_label_text_anchor";
import chart_global_layout_Padding from "@patternfly/react-tokens/dist/esm/chart_global_layout_Padding";
import chart_global_layout_Height from "@patternfly/react-tokens/dist/esm/chart_global_layout_Height";
import chart_global_layout_Width from "@patternfly/react-tokens/dist/esm/chart_global_layout_Width";
import chart_global_stroke_line_cap from "@patternfly/react-tokens/dist/esm/chart_global_stroke_line_cap";
import chart_global_stroke_line_join from "@patternfly/react-tokens/dist/esm/chart_global_stroke_line_join";
import chart_area_data_Fill from "@patternfly/react-tokens/dist/esm/chart_area_data_Fill";
import chart_area_Opacity from "@patternfly/react-tokens/dist/esm/chart_area_Opacity";
import chart_area_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_area_stroke_Width";
import chart_axis_axis_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_axis_axis_stroke_Width";
import chart_axis_axis_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_axis_axis_stroke_Color";
import chart_axis_axis_Fill from "@patternfly/react-tokens/dist/esm/chart_axis_axis_Fill";
import chart_axis_axis_label_Padding from "@patternfly/react-tokens/dist/esm/chart_axis_axis_label_Padding";
import chart_axis_axis_label_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_axis_axis_label_stroke_Color";
import chart_axis_grid_Fill from "@patternfly/react-tokens/dist/esm/chart_axis_grid_Fill";
import chart_axis_grid_PointerEvents from "@patternfly/react-tokens/dist/esm/chart_axis_grid_PointerEvents";
import chart_axis_tick_Fill from "@patternfly/react-tokens/dist/esm/chart_axis_tick_Fill";
import chart_axis_tick_Size from "@patternfly/react-tokens/dist/esm/chart_axis_tick_Size";
import chart_axis_tick_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_axis_tick_stroke_Color";
import chart_axis_tick_Width from "@patternfly/react-tokens/dist/esm/chart_axis_tick_Width";
import chart_axis_tick_label_Fill from "@patternfly/react-tokens/dist/esm/chart_axis_tick_label_Fill";
import chart_bar_Width from "@patternfly/react-tokens/dist/esm/chart_bar_Width";
import chart_bar_data_stroke from "@patternfly/react-tokens/dist/esm/chart_bar_data_stroke";
import chart_bar_data_Fill from "@patternfly/react-tokens/dist/esm/chart_bar_data_Fill";
import chart_bar_data_Padding from "@patternfly/react-tokens/dist/esm/chart_bar_data_Padding";
import chart_bar_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_bar_data_stroke_Width";
import chart_boxplot_max_Padding from "@patternfly/react-tokens/dist/esm/chart_boxplot_max_Padding";
import chart_boxplot_max_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_boxplot_max_stroke_Color";
import chart_boxplot_max_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_boxplot_max_stroke_Width";
import chart_boxplot_median_Padding from "@patternfly/react-tokens/dist/esm/chart_boxplot_median_Padding";
import chart_boxplot_median_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_boxplot_median_stroke_Color";
import chart_boxplot_median_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_boxplot_median_stroke_Width";
import chart_boxplot_min_Padding from "@patternfly/react-tokens/dist/esm/chart_boxplot_min_Padding";
import chart_boxplot_min_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_boxplot_min_stroke_Width";
import chart_boxplot_min_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_boxplot_min_stroke_Color";
import chart_boxplot_lower_quartile_Padding from "@patternfly/react-tokens/dist/esm/chart_boxplot_lower_quartile_Padding";
import chart_boxplot_lower_quartile_Fill from "@patternfly/react-tokens/dist/esm/chart_boxplot_lower_quartile_Fill";
import chart_boxplot_upper_quartile_Padding from "@patternfly/react-tokens/dist/esm/chart_boxplot_upper_quartile_Padding";
import chart_boxplot_upper_quartile_Fill from "@patternfly/react-tokens/dist/esm/chart_boxplot_upper_quartile_Fill";
import chart_boxplot_box_Width from "@patternfly/react-tokens/dist/esm/chart_boxplot_box_Width";
import chart_candelstick_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_candelstick_data_stroke_Width";
import chart_candelstick_data_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_candelstick_data_stroke_Color";
import chart_candelstick_candle_positive_Color from "@patternfly/react-tokens/dist/esm/chart_candelstick_candle_positive_Color";
import chart_candelstick_candle_negative_Color from "@patternfly/react-tokens/dist/esm/chart_candelstick_candle_negative_Color";
import chart_errorbar_BorderWidth from "@patternfly/react-tokens/dist/esm/chart_errorbar_BorderWidth";
import chart_errorbar_data_Fill from "@patternfly/react-tokens/dist/esm/chart_errorbar_data_Fill";
import chart_errorbar_data_Opacity from "@patternfly/react-tokens/dist/esm/chart_errorbar_data_Opacity";
import chart_errorbar_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_errorbar_data_stroke_Width";
import chart_errorbar_data_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_errorbar_data_stroke_Color";
import chart_legend_gutter_Width from "@patternfly/react-tokens/dist/esm/chart_legend_gutter_Width";
import chart_legend_orientation from "@patternfly/react-tokens/dist/esm/chart_legend_orientation";
import chart_legend_title_orientation from "@patternfly/react-tokens/dist/esm/chart_legend_title_orientation";
import chart_legend_data_type from "@patternfly/react-tokens/dist/esm/chart_legend_data_type";
import chart_legend_title_Padding from "@patternfly/react-tokens/dist/esm/chart_legend_title_Padding";
import chart_line_data_Fill from "@patternfly/react-tokens/dist/esm/chart_line_data_Fill";
import chart_line_data_Opacity from "@patternfly/react-tokens/dist/esm/chart_line_data_Opacity";
import chart_line_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_line_data_stroke_Width";
import chart_line_data_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_line_data_stroke_Color";
import chart_pie_Padding from "@patternfly/react-tokens/dist/esm/chart_pie_Padding";
import chart_pie_data_Padding from "@patternfly/react-tokens/dist/esm/chart_pie_data_Padding";
import chart_pie_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_pie_data_stroke_Width";
import chart_pie_data_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_pie_data_stroke_Color";
import chart_pie_labels_Padding from "@patternfly/react-tokens/dist/esm/chart_pie_labels_Padding";
import chart_pie_Height from "@patternfly/react-tokens/dist/esm/chart_pie_Height";
import chart_pie_Width from "@patternfly/react-tokens/dist/esm/chart_pie_Width";
import chart_scatter_data_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_scatter_data_stroke_Color";
import chart_scatter_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_scatter_data_stroke_Width";
import chart_scatter_data_Opacity from "@patternfly/react-tokens/dist/esm/chart_scatter_data_Opacity";
import chart_scatter_data_Fill from "@patternfly/react-tokens/dist/esm/chart_scatter_data_Fill";
import chart_stack_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_stack_data_stroke_Width";
import chart_tooltip_corner_radius from "@patternfly/react-tokens/dist/esm/chart_tooltip_corner_radius";
import chart_tooltip_pointer_length from "@patternfly/react-tokens/dist/esm/chart_tooltip_pointer_length";
import chart_tooltip_Fill from "@patternfly/react-tokens/dist/esm/chart_tooltip_Fill";
import chart_tooltip_flyoutStyle_corner_radius from "@patternfly/react-tokens/dist/esm/chart_tooltip_flyoutStyle_corner_radius";
import chart_tooltip_flyoutStyle_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_tooltip_flyoutStyle_stroke_Width";
import chart_tooltip_flyoutStyle_PointerEvents from "@patternfly/react-tokens/dist/esm/chart_tooltip_flyoutStyle_PointerEvents";
import chart_tooltip_flyoutStyle_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_tooltip_flyoutStyle_stroke_Color";
import chart_tooltip_flyoutStyle_Fill from "@patternfly/react-tokens/dist/esm/chart_tooltip_flyoutStyle_Fill";
import chart_tooltip_pointer_Width from "@patternfly/react-tokens/dist/esm/chart_tooltip_pointer_Width";
import chart_tooltip_Padding from "@patternfly/react-tokens/dist/esm/chart_tooltip_Padding";
import chart_tooltip_PointerEvents from "@patternfly/react-tokens/dist/esm/chart_tooltip_PointerEvents";
import chart_voronoi_data_Fill from "@patternfly/react-tokens/dist/esm/chart_voronoi_data_Fill";
import chart_voronoi_data_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_voronoi_data_stroke_Color";
import chart_voronoi_data_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_voronoi_data_stroke_Width";
import chart_voronoi_labels_Fill from "@patternfly/react-tokens/dist/esm/chart_voronoi_labels_Fill";
import chart_voronoi_labels_Padding from "@patternfly/react-tokens/dist/esm/chart_voronoi_labels_Padding";
import chart_voronoi_labels_PointerEvents from "@patternfly/react-tokens/dist/esm/chart_voronoi_labels_PointerEvents";
import chart_voronoi_flyout_stroke_Width from "@patternfly/react-tokens/dist/esm/chart_voronoi_flyout_stroke_Width";
import chart_voronoi_flyout_PointerEvents from "@patternfly/react-tokens/dist/esm/chart_voronoi_flyout_PointerEvents";
import chart_voronoi_flyout_stroke_Color from "@patternfly/react-tokens/dist/esm/chart_voronoi_flyout_stroke_Color";
import chart_voronoi_flyout_stroke_Fill from "@patternfly/react-tokens/dist/esm/chart_voronoi_flyout_stroke_Fill";
// Note: Values must be in pixles
// Typography
//
// Note: Victory's approximateTextSize function uses specific character widths and does not work with font variables
// See https://github.com/patternfly/patternfly-react/issues/5300
const TYPOGRAPHY_FONT_FAMILY = chart_global_FontFamily.value.replace(/ /g, '');
const TYPOGRAPHY_LETTER_SPACING = chart_global_letter_spacing.value;
const TYPOGRAPHY_FONT_SIZE = chart_global_FontSize_sm.value;
// Labels
const LABEL_PROPS = {
    fontFamily: TYPOGRAPHY_FONT_FAMILY,
    fontSize: TYPOGRAPHY_FONT_SIZE,
    letterSpacing: TYPOGRAPHY_LETTER_SPACING,
    padding: chart_global_label_Padding.value,
    stroke: chart_global_label_stroke.value
};
const LABEL_CENTERED_PROPS = Object.assign(Object.assign({}, LABEL_PROPS), { textAnchor: chart_global_label_text_anchor.value });
// Layout
const LAYOUT_PROPS = {
    padding: chart_global_layout_Padding.value,
    height: chart_global_layout_Height.value,
    width: chart_global_layout_Width.value
};
// Strokes
const STROKE_LINE_CAP = chart_global_stroke_line_cap.value;
const STROKE_LINE_JOIN = chart_global_stroke_line_join.value;
// Victory theme properties only
export const BaseTheme = {
    area: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_area_data_Fill.value,
                fillOpacity: chart_area_Opacity.value,
                // Omit stroke to add a line border from color scale
                // stroke: chart_global_label_stroke.value,
                strokeWidth: chart_area_stroke_Width.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    axis: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            axis: {
                fill: chart_axis_axis_Fill.value,
                strokeWidth: chart_axis_axis_stroke_Width.value,
                stroke: chart_axis_axis_stroke_Color.value,
                strokeLinecap: STROKE_LINE_CAP,
                strokeLinejoin: STROKE_LINE_JOIN
            },
            axisLabel: Object.assign(Object.assign({}, LABEL_CENTERED_PROPS), { padding: chart_axis_axis_label_Padding.value, stroke: chart_axis_axis_label_stroke_Color.value }),
            grid: {
                fill: chart_axis_grid_Fill.value,
                stroke: 'none',
                pointerEvents: chart_axis_grid_PointerEvents.value,
                strokeLinecap: STROKE_LINE_CAP,
                strokeLinejoin: STROKE_LINE_JOIN
            },
            ticks: {
                fill: chart_axis_tick_Fill.value,
                size: chart_axis_tick_Size.value,
                stroke: chart_axis_tick_stroke_Color.value,
                strokeLinecap: STROKE_LINE_CAP,
                strokeLinejoin: STROKE_LINE_JOIN,
                strokeWidth: chart_axis_tick_Width.value
            },
            tickLabels: Object.assign(Object.assign({}, LABEL_PROPS), { fill: chart_axis_tick_label_Fill.value })
        } }),
    bar: Object.assign(Object.assign({}, LAYOUT_PROPS), { barWidth: chart_bar_Width.value, style: {
            data: {
                fill: chart_bar_data_Fill.value,
                padding: chart_bar_data_Padding.value,
                stroke: chart_bar_data_stroke.value,
                strokeWidth: chart_bar_data_stroke_Width.value
            },
            labels: LABEL_PROPS
        } }),
    boxplot: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            max: {
                padding: chart_boxplot_max_Padding.value,
                stroke: chart_boxplot_max_stroke_Color.value,
                strokeWidth: chart_boxplot_max_stroke_Width.value
            },
            maxLabels: LABEL_PROPS,
            median: {
                padding: chart_boxplot_median_Padding.value,
                stroke: chart_boxplot_median_stroke_Color.value,
                strokeWidth: chart_boxplot_median_stroke_Width.value
            },
            medianLabels: LABEL_PROPS,
            min: {
                padding: chart_boxplot_min_Padding.value,
                stroke: chart_boxplot_min_stroke_Color.value,
                strokeWidth: chart_boxplot_min_stroke_Width.value
            },
            minLabels: LABEL_PROPS,
            q1: {
                fill: chart_boxplot_lower_quartile_Fill.value,
                padding: chart_boxplot_lower_quartile_Padding.value
            },
            q1Labels: LABEL_PROPS,
            q3: {
                fill: chart_boxplot_upper_quartile_Fill.value,
                padding: chart_boxplot_upper_quartile_Padding.value
            },
            q3Labels: LABEL_PROPS
        }, boxWidth: chart_boxplot_box_Width.value }),
    candlestick: Object.assign(Object.assign({}, LAYOUT_PROPS), { candleColors: {
            positive: chart_candelstick_candle_positive_Color.value,
            negative: chart_candelstick_candle_negative_Color.value
        }, style: {
            data: {
                stroke: chart_candelstick_data_stroke_Color.value,
                strokeWidth: chart_candelstick_data_stroke_Width.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    chart: Object.assign({}, LAYOUT_PROPS),
    errorbar: Object.assign(Object.assign({}, LAYOUT_PROPS), { borderWidth: chart_errorbar_BorderWidth.value, style: {
            data: {
                fill: chart_errorbar_data_Fill.value,
                opacity: chart_errorbar_data_Opacity.value,
                stroke: chart_errorbar_data_stroke_Color.value,
                strokeWidth: chart_errorbar_data_stroke_Width.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    group: Object.assign({}, LAYOUT_PROPS),
    legend: {
        gutter: chart_legend_gutter_Width.value,
        orientation: chart_legend_orientation.value,
        titleOrientation: chart_legend_title_orientation.value,
        style: {
            data: {
                type: chart_legend_data_type.value
            },
            labels: LABEL_PROPS,
            title: Object.assign(Object.assign({}, LABEL_PROPS), { fontSize: TYPOGRAPHY_FONT_SIZE, padding: chart_legend_title_Padding.value })
        }
    },
    line: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_line_data_Fill.value,
                opacity: chart_line_data_Opacity.value,
                stroke: chart_line_data_stroke_Color.value,
                strokeWidth: chart_line_data_stroke_Width.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    pie: {
        padding: chart_pie_Padding.value,
        style: {
            data: {
                padding: chart_pie_data_Padding.value,
                stroke: chart_pie_data_stroke_Color.value,
                strokeWidth: chart_pie_data_stroke_Width.value
            },
            labels: Object.assign(Object.assign({}, LABEL_PROPS), { padding: chart_pie_labels_Padding.value })
        },
        height: chart_pie_Height.value,
        width: chart_pie_Width.value
    },
    scatter: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_scatter_data_Fill.value,
                opacity: chart_scatter_data_Opacity.value,
                stroke: chart_scatter_data_stroke_Color.value,
                strokeWidth: chart_scatter_data_stroke_Width.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    stack: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                strokeWidth: chart_stack_data_stroke_Width.value
            }
        } }),
    tooltip: {
        cornerRadius: chart_tooltip_corner_radius.value,
        flyoutPadding: chart_tooltip_Padding.value,
        flyoutStyle: {
            cornerRadius: chart_tooltip_flyoutStyle_corner_radius.value,
            fill: chart_tooltip_flyoutStyle_Fill.value,
            pointerEvents: chart_tooltip_flyoutStyle_PointerEvents.value,
            stroke: chart_tooltip_flyoutStyle_stroke_Color.value,
            strokeWidth: chart_tooltip_flyoutStyle_stroke_Width.value
        },
        pointerLength: chart_tooltip_pointer_length.value,
        pointerWidth: chart_tooltip_pointer_Width.value,
        style: {
            fill: chart_tooltip_Fill.value,
            pointerEvents: chart_tooltip_PointerEvents.value
        }
    },
    voronoi: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_voronoi_data_Fill.value,
                stroke: chart_voronoi_data_stroke_Color.value,
                strokeWidth: chart_voronoi_data_stroke_Width.value
            },
            labels: Object.assign(Object.assign({}, LABEL_CENTERED_PROPS), { fill: chart_voronoi_labels_Fill.value, padding: chart_voronoi_labels_Padding.value, pointerEvents: chart_voronoi_labels_PointerEvents.value }),
            // Note: These properties override tooltip
            flyout: {
                fill: chart_voronoi_flyout_stroke_Fill.value,
                pointerEvents: chart_voronoi_flyout_PointerEvents.value,
                stroke: chart_voronoi_flyout_stroke_Color.value,
                strokeWidth: chart_voronoi_flyout_stroke_Width.value
            }
        } })
};
//# sourceMappingURL=base-theme.js.map