import React from 'react';
import { ViewLevel } from '@kui-shell/plugin-client-common';
import { KubeContext } from '@kui-shell/plugin-kubectl';
interface Props {
    className?: string;
}
interface State {
    currentContext: string;
    allContexts: KubeContext[];
    viewLevel: ViewLevel;
}
export declare let ready: boolean;
export default class CurrentContext extends React.PureComponent<Props, State> {
    private readonly handler;
    private readonly handlerForConfigChange;
    private readonly handlerNotCallingKubectl;
    constructor(props: Props);
    /** @return e.g. name/uuid -> name; or name:nnnn -> name */
    private renderName;
    /** Avoid recomputation for a flurry of events */
    private last;
    private debounce;
    private getCurrentContextFromChange;
    private setNoContext;
    private reportCurrentContext;
    private getCurrentContextFromTab;
    /** @return UI for listing full context table */
    private listContext;
    /** @return the header for the Popover component */
    private popoverHeader;
    private switchContext;
    private switchContextDescription;
    /** @return the body for the Popover component */
    private popoverBody;
    /** @return desired Popover model */
    private popover;
    /**
     * Once we have mounted, we immediately check the current branch,
     * and schedule an update based on standard REPL events.
     *
     */
    componentDidMount(): void;
    /** Bye! */
    componentWillUnmount(): void;
    render(): JSX.Element;
}
export {};
