"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = fabricate404Table;

var _unify = require("./unify");

var _trafficLight = _interopRequireDefault(require("../../../lib/model/traffic-light"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @return a Row for the given name in `names` with an Offline status.
 *
 */
function fabricate404Row(name, kind) {
  return (0, _unify.rowWith)(name, kind, 'Offline', _trafficLight.default.Red);
}
/**
 * @return a Table with one row per given name in `names`, each row
 * with an Offline status.
 *
 */


function fabricate404Table(names, kind) {
  return {
    header: _unify.standardStatusHeader,
    body: names.map(name => fabricate404Row(name, kind))
  };
}