"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createDirect;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

var _fetchFile = require("../../../lib/util/fetch-file");

var _explain = require("../../kubectl/explain");

var _options = require("../../kubectl/options");

var _status = _interopRequireDefault(require("./status"));

var _errors = _interopRequireDefault(require("./errors"));

var _url = require("./url");

var _headers = require("./headers");

var _states = require("../../../lib/model/states");

var _util = require("../../../lib/util/util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugin-kubectl/controller/client/direct/create');

function withErrors(watchPart, errors) {
  if (errors.length === 0) {
    return watchPart;
  } else if ((0, _core.isTable)(watchPart)) {
    return [watchPart, ...errors.map(_ => _.message)];
  } else {
    return [...watchPart, ...errors.map(_ => _.message)];
  }
}

function createDirect(args, verb, _kind) {
  return __awaiter(this, void 0, void 0, function* () {
    // For now, we only handle create-by-name
    if (!(0, _options.getFileFromArgv)(args) && !(0, _options.getLabel)(args) && !args.parsedOptions['dry-run'] && !args.parsedOptions['field-selector']) {
      const explainedKind = yield _kind || (0, _explain.getKindAndVersion)((0, _util.getCommandFromArgs)(args), args, args.argvNoOptions[args.argvNoOptions.indexOf(verb) + 1]);
      const {
        kind,
        version
      } = explainedKind; // the last undefined is needed: we don't want to include a name in the URL path

      const formatUrl = yield (0, _url.urlFormatterForArgs)(args, explainedKind);
      const kindIdx = args.argvNoOptions.indexOf('create') + 1;
      const names = args.argvNoOptions.slice(kindIdx + 1); // re: context and kubeconfig, see https://github.com/IBM/kui/issues/7023

      if (verb === 'create' && kind === 'Namespace' && version === 'v1' && names.length > 0 && !args.parsedOptions.context && !args.parsedOptions.kubeconfig) {
        // WARNING: this is namespace-specific for now!
        const data = names.map(name => ({
          apiVersion: 'v1',
          kind: 'Namespace',
          metadata: {
            creationTimestamp: null,
            name
          },
          spec: {},
          status: {}
        }));
        const urls = names.map(formatUrl.bind(undefined, true, false, undefined)).map(url => `${url}?fieldManager=kubectl-create`).join(',');
        debug('attempting create namespace direct', names, urls);
        const responses = yield (0, _fetchFile.fetchFile)(args.REPL, urls, {
          method: 'post',
          headers: _headers.headersForPlainRequest,
          returnErrors: true,
          data
        }); // then dissect it into errors and non-errors; the last true means return, don't throw, errors

        const {
          errors,
          okIndices,
          ok
        } = yield (0, _errors.default)(responses, formatUrl, kind, args.REPL, true);

        if (ok.length === 0) {
          // all errors? then tell the user about them (no need to re-invoke the CLI)
          if (errors.length > 0 && errors.every(_core.is404or409)) {
            return errors.map(_ => _.message).join('\n');
          } // otherwise: intentional fall-through, returning void; let
          // kubectl CLI handle the errors for now

        } else {
          // success!
          const groups = [{
            names: okIndices.map(idx => names[idx]),
            namespace: yield (0, _options.getNamespace)(args),
            explainedKind
          }];
          const watchPart = yield (0, _status.default)(args, groups, _states.FinalState.OnlineLike);

          if (watchPart) {
            return withErrors(watchPart, errors);
          }
        }
      }
    }
  });
}