"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.doGetDeployment = doGetDeployment;
exports.default = void 0;

var _core = require("@kui-shell/core");

var _expound = _interopRequireDefault(require("../../lib/util/expound"));

var _get = require("./get");

var _trafficLight = _interopRequireDefault(require("../../lib/model/traffic-light"));

var _util = require("../../lib/util/util");

var _formatTable = require("../../lib/view/formatTable");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * As with a normal get, but transform the Ready column to be a Status column
 *
 */
function doGetDeployment(args) {
  return __awaiter(this, void 0, void 0, function* () {
    const table = yield (0, _get.doGet)((0, _util.getCommandFromArgs)(args))(args);

    if ((0, _core.isTable)(table) && table.header) {
      (0, _formatTable.hideWithSidecar)('up-to-date', table);
      const readyIdx = table.header.attributes.findIndex(_ => /Ready/i.test(_.key));

      if (readyIdx >= 0) {
        (0, _formatTable.showAlways)(readyIdx, table);
        table.statusColumnIdx = readyIdx;
        table.body.forEach(row => {
          const attr = row.attributes[readyIdx];

          if (attr && attr.value) {
            const match = attr.value.match(/(\d+)\/(\d+)/);

            if (match && match.length === 3) {
              attr.tag = 'badge';
              const numerator = parseInt(match[1], 10);
              const denominator = parseInt(match[2], 10);
              attr.css = numerator === denominator ? _trafficLight.default.Green : numerator === 0 ? _trafficLight.default.Red : _trafficLight.default.Yellow;
            }
          }
        });
      }
    }

    return table;
  });
}

var _default = commandTree => {
  (0, _expound.default)('deployment', 'deploy', 'v1', 'apps').forEach(deployment => {
    ;
    ['k', 'kubectl', 'oc'].forEach(kubectl => {
      commandTree.listen(`/${kubectl}/get/${deployment}`, doGetDeployment, _get.getFlags);
    });
  });
};

exports.default = _default;