"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flags = flags;
exports.default = void 0;

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const defaultBooleans = ['w', 'watch', 'watch-only', 'A', 'all-namespaces', 'ignore-not-found', 'no-headers', // exec
'i', 'it', 'ti', 'stdin', 't', 'tty', 'R', 'recursive', 'server-print', 'show-kind', 'show-labels'];

function flags(booleans = []) {
  return {
    flags: {
      configuration: {
        // disable yargs-parser being clever with -lapp=name
        'short-option-groups': false,
        // disable -n foo -n bar from being parsed as -n foo,bar
        'duplicate-arguments-array': false
      },
      // Notes on narg: to prevent yargs-parser from processing "--watch true" into watch:true
      narg: {
        w: 0,
        watch: 0,
        'watch-only': 0
      },
      string: ['_'],
      boolean: booleans.concat(defaultBooleans)
    },
    noCoreRedirect: true
  };
}

const defaultFlags = flags();
var _default = defaultFlags;
exports.default = _default;