"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.label = void 0;

var _react = _interopRequireDefault(require("react"));

var _pluginClientCommon = require("@kui-shell/plugin-client-common");

var _core = require("@kui-shell/core");

var _edit = require("../../../controller/kubectl/edit");

var _2 = require("../../../");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common', 'editor');
/** Mode identifier */

const mode = 'edit-button';
/** Mode label; intentionally no i18n */

const label = strings('Edit');
/** Should we decorate the given resource with an Edit button? */

exports.label = label;

function isEditable(resource) {
  return (0, _2.isCrudableKubeResource)(resource) && !(0, _edit.isEditable)(resource);
}
/**
 * The YAML mode applies to all KubeResources, and simply extracts the
 * raw `data` field from the resource; note how we indicate that this
 * raw data has a yaml content type.
 *
 */


const yamlMode = {
  when: isEditable,
  mode: {
    mode,
    label,
    icon: _react.default.createElement(_pluginClientCommon.Icons, {
      icon: "Edit"
    }),
    // we want to execute the command in place of the current block,
    // rather than in a new block
    inPlace: true,
    kind: 'drilldown',
    command: (_, resource, args) => `${(0, _2.getCommandFromArgs)(args)} edit ${(0, _2.fqnOf)(resource)}`
  }
};
var _default = yamlMode;
exports.default = _default;