"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventsBadge = exports.eventsMode = void 0;

var _core = require("@kui-shell/core");

var _cssForValue = _interopRequireDefault(require("../css-for-value"));

var _util = require("../../util/util");

var _trafficLight = _interopRequireDefault(require("../../model/traffic-light"));

var _options = require("../../../controller/kubectl/options");

var _resource = require("../../model/resource");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-kubectl');
/**
 * @return whether the given resource might possibly have events;
 * since Events never have Events, we can exclude those always
 *
 */

function hasEvents(resource) {
  return (0, _resource.isCrudableKubeResource)(resource) && !(0, _resource.isEvent)(resource) && (0, _resource.isNamespaced)(resource);
}
/**
 * Extract the events
 *
 */


function command(_, resource, args) {
  // limit events to those intersecting with the giving resource
  const filter = `involvedObject.apiVersion=${resource.apiVersion},involvedObject.kind=${resource.kind},involvedObject.name=${resource.metadata.name},involvedObject.namespace=${resource.metadata.namespace}`; // this is the command that will fetch the events table; we specify a watchable table

  const argv = [(0, _util.getCommandFromArgs)(args), 'get', 'events', '--field-selector', filter, '-n', resource.metadata.namespace, '-w'];
  return (0, _options.withKubeconfigFrom)(args, argv.join(' '));
}
/**
 * Add a Events mode button to the given modes model, if called for by
 * the given resource.
 *
 */


const eventsMode = {
  when: hasEvents,
  mode: {
    mode: 'events',
    label: strings('Show Events'),
    kind: 'drilldown',
    showRelatedResource: true,
    command
  }
};
exports.eventsMode = eventsMode;
const eventsBadge = {
  when: _resource.isEvent,
  badge: event => {
    const cssFromReason = _cssForValue.default[event.reason];
    return {
      title: cssFromReason ? event.reason : event.type,
      css: cssFromReason || (event.type === 'Error' ? _trafficLight.default.Red : event.type === 'Warning' ? _trafficLight.default.Yellow : undefined)
    };
  }
};
exports.eventsBadge = eventsBadge;