"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.none = none;
exports.age = age;
exports.default = GenericSummary;

var _prettyMs = _interopRequireDefault(require("pretty-ms"));

var _tableToMap = _interopRequireDefault(require("../../table-to-map"));

var _options = require("../../../../../controller/kubectl/options");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function none() {
  return '<none>';
}

function age({
  metadata
}, now = new Date()) {
  return (0, _prettyMs.default)((typeof now === 'string' ? new Date(now) : now).getTime() - new Date(metadata.creationTimestamp).getTime());
}

function GenericSummary(resource, repl) {
  return __awaiter(this, void 0, void 0, function* () {
    // a command that will fetch a single-row table
    const cmd = (0, _options.withKubeconfigFrom)(resource.originatingCommand, `kubectl get ${resource.kind} ${resource.metadata.name} -n ${resource.metadata.namespace} -o wide`);
    return (0, _tableToMap.default)(yield repl.qexec(cmd));
  });
}