"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultSummaryMap = getDefaultSummaryMap;
exports.default = void 0;

var _core = require("@kui-shell/core");

var _tableToMap = _interopRequireDefault(require("./table-to-map"));

var _util = require("../../util/util");

var _fqn = require("../../../controller/kubectl/fqn");

var _resource = require("../../model/resource");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl');

function getDefaultSummaryMap(tab, resource, args) {
  // a command that will fetch a single-row table
  const cmd = `${(0, _util.getCommandFromArgs)(args)} get ${(0, _fqn.fqnOf)(resource)} -o wide`; // fetch the table model and the dump function from js-yaml

  return tab.REPL.qexec(cmd).then(_tableToMap.default);
}
/**
 * Extract the events
 *
 */


function content(tab, cm, args) {
  return __awaiter(this, void 0, void 0, function* () {
    const [map, {
      dump
    }] = yield Promise.all([getDefaultSummaryMap(tab, cm, args), Promise.resolve().then(() => require('js-yaml'))]);

    if (cm.data) {
      delete map.Data;

      try {
        for (const key in cm.data) {
          if (typeof cm.data[key] === 'string') {
            map[key] = cm.data[key];
          }
        }
      } catch (err) {
        console.error('error parsing configmap data', err);
      }
    }

    return {
      content: dump(map),
      contentType: 'yaml'
    };
  });
}
/**
 * Add a Events mode button to the given modes model, if called for by
 * the given resource.
 *
 */


const mode = {
  when: _resource.isConfigMap,
  mode: {
    mode: 'summary',
    label: strings('summary'),
    content,
    priority: 10 // override default Summary

  }
};
var _default = mode;
exports.default = _default;