"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _resource = require("../../model/resource");

var _getNamespaces = require("../../../controller/kubectl/get-namespaces");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const mode = 'resources';
const label = (0, _core.i18n)('plugin-kubectl')(mode);
/**
 * The content renderer for the summary tab
 *
 */

function content(tab, resource) {
  return (0, _getNamespaces.doSummarizeNamedNamespace)(tab, resource.metadata.name);
}
/**
 * This Summary mode applies to Namespace resources
 *
 */


const summaryMode = {
  when: _resource.isNamespace,
  mode: {
    mode,
    label,
    content
  }
};
var _default = summaryMode;
exports.default = _default;