"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.podMode = void 0;

var _util = require("../../util/util");

var _selectors = require("../../util/selectors");

var _resource = require("../../model/resource");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * Render the tabular pods view
 *
 */
function renderPods(tab, resource, args) {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      selector
    } = resource.spec;
    const getPods = selector ? `${(0, _util.getCommandFromArgs)(args)} get pods ${(0, _selectors.selectorToString)(selector)} -n "${resource.metadata.namespace}"` : `${(0, _util.getCommandFromArgs)(args)} get pods ${resource.status.podName} -n "${resource.metadata.namespace}"`;
    const tableModel = tab.REPL.qexec(getPods);
    return tableModel;
  });
}
/**
 * Resource filter: if the resource refers to a pod in some fashion
 *
 */


function hasPods(resource) {
  return (0, _resource.isKubeResource)(resource) && ((0, _resource.isDeployment)(resource) || (0, _resource.isReplicaSet)(resource) || resource.status !== undefined && resource.status.podName !== undefined);
}
/**
 * Add a Pods mode button to the given modes model, if called for by
 * the given resource.
 *
 */


const podMode = {
  when: hasPods,
  mode: {
    mode: 'pods',
    label: 'Pods',
    content: renderPods
  }
};
exports.podMode = podMode;
var _default = podMode;
exports.default = _default;