/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import { is404 } from '@kui-shell/core';
import { fetchFile } from '../../../lib/util/fetch-file';
import { getKindAndVersion } from '../../kubectl/explain';
import { getFileFromArgv, getLabel, getNamespace } from '../../kubectl/options';
import status from './status';
import handleErrors from './errors';
import { urlFormatterForArgs } from './url';
import { FinalState } from '../../../lib/model/states';
import { getCommandFromArgs } from '../../../lib/util/util';
import { headersForPlainRequest as headers } from './headers';
const debug = Debug('plugin-kubectl/controller/client/direct/delete');
export default function deleteDirect(args, _kind) {
    return __awaiter(this, void 0, void 0, function* () {
        // For now, we only handle delete-by-name
        // re: context and kubeconfig, see https://github.com/IBM/kui/issues/7023
        if (!getFileFromArgv(args) &&
            !getLabel(args) &&
            !args.parsedOptions['dry-run'] &&
            !args.parsedOptions['field-selector'] &&
            !args.parsedOptions.context &&
            !args.parsedOptions.kubeconfig) {
            const explainedKind = yield (_kind ||
                getKindAndVersion(getCommandFromArgs(args), args, args.argvNoOptions[args.argvNoOptions.indexOf('delete') + 1]));
            const { kind } = explainedKind;
            const formatUrl = yield urlFormatterForArgs(args, explainedKind);
            // this tells the apiServer that we want the delete to return right away
            const data = { propagationPolicy: 'Background' };
            const kindIdx = args.argvNoOptions.indexOf('delete') + 1;
            const names = args.argvNoOptions.slice(kindIdx + 1);
            if (kind && names.length > 0) {
                const urls = names.map(formatUrl.bind(undefined, true, false)).join(',');
                debug('attempting delete direct', urls);
                const responses = yield fetchFile(args.REPL, urls, { method: 'delete', headers, returnErrors: true, data });
                // then dissect it into errors and non-errors
                const { errors, ok } = yield handleErrors(responses, formatUrl, kind, args.REPL);
                if (ok.length === 0) {
                    // all 404 errors? then tell the user about them (no need to re-invoke the CLI)
                    if (errors.length > 0 && errors.every(is404)) {
                        return errors.map(_ => _.message).join('\n');
                    }
                    // otherwise: intentional fall-through, returning void; let
                    // kubectl CLI handle the errors for now
                }
                else {
                    // success!
                    const groups = [
                        {
                            names,
                            namespace: yield getNamespace(args),
                            explainedKind
                        }
                    ];
                    return status(args, groups, FinalState.OfflineLike);
                }
            }
        }
    });
}
//# sourceMappingURL=delete.js.map