import { Arguments, Table, Watchable } from '@kui-shell/core';
import { Group } from './group';
import { KubeOptions } from '../../kubectl/options';
import { FinalState } from '../../../lib/model/states';
/**
 * If at least one resource is not in the given `finalState`, return a
 * single unified `Table & Watchable` that will monitor the given
 * `groups` of resources until they have all reached the given
 * `FinalState`.
 *
 * If the desired final state is `OfflineLike`, and all of the
 * resources are already offline, return a plain `Table` with all rows
 * marked as Offline.
 *
 * If none of the groups is valid (e.g. by specifying a bogus Kind),
 * return a `string[]` that conveys the error messages.
 *
 * Finally, this function may refuse to handle the request, in which case
 * it will retur `void`.
 *
 */
export default function watchMulti(args: Arguments<KubeOptions>, groups: Group[], finalState?: FinalState, drilldownCommand?: string, file?: string, isWatchRequest?: boolean): Promise<void | string[] | Table | (Table & Watchable)>;
