/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import defaultFlags from './flags';
import { isDryRun, isEntityFormat, formatOf } from './options';
import { doExecWithStatus, exec, reallyNeedsPty } from './exec';
import createDirect from '../client/direct/create';
import { FinalState } from '../../lib/model/states';
import { isUsage, doHelp } from '../../lib/util/help';
import { doGetAsEntity, viewTransformer } from './get';
const debug = Debug('plugin-kubectl/controller/kubectl/create');
/** The create-like verbs we will handle */
const verbs = ['create', 'apply'];
export const doCreate = (verb, command = 'kubectl') => (args) => __awaiter(void 0, void 0, void 0, function* () {
    if (isUsage(args)) {
        return doHelp(command, args);
    }
    else {
        if (isDryRun(args)) {
            const raw = yield exec(args, undefined, command);
            if (isEntityFormat(formatOf(args)) && !reallyNeedsPty(args)) {
                const entity = yield doGetAsEntity(args, raw);
                return entity;
            }
            else {
                return raw.content.stdout;
            }
        }
        else {
            try {
                const response = yield createDirect(args, verb);
                if (response) {
                    return response;
                }
                else {
                    debug('createDirect falling through to CLI impl');
                }
            }
            catch (err) {
                if (err.code === 404) {
                    throw err;
                }
                else {
                    console.error('Error in direct create. Falling back to CLI create.', err.code, err);
                }
            }
            // Note: the kuiSourceRef info will be added by `doStatus` in
            // ./status.ts, which is called by `doExecWithStatus`
            return doExecWithStatus(verb, FinalState.OnlineLike, command)(args);
        }
    }
});
export const applyFlag = Object.assign({}, defaultFlags, { viewTransformer });
export default (registrar) => {
    verbs.forEach(verb => {
        const handler = doCreate(verb);
        registrar.listen(`/kubectl/${verb}`, handler, applyFlag);
        registrar.listen(`/k/${verb}`, handler, applyFlag);
    });
};
//# sourceMappingURL=create.js.map