import { Breadcrumb, Table, Row, Arguments, KResponse, MixedResponse } from '@kui-shell/core';
import { KubeResource, MetaTable } from '../model/resource';
import { RawResponse } from '../../controller/kubectl/response';
import KubeOptions from '../../controller/kubectl/options';
import cssForValue from './css-for-value';
export { cssForValue };
/** decorate certain columns specially */
export declare const outerCSSForKey: {
    NAME: string;
    READY: string;
    KIND: string;
    NAMESPACE: string;
    MESSAGE: string;
    TYPE: string;
    CLUSTER: string;
    AUTHINFO: string;
    REFERENCE: string;
    'CREATED AT': string;
    CURRENT: string;
    DESIRED: string;
    'LAST SEEN': string;
    'FIRST SEEN': string;
    COUNT: string;
    APIGROUP: string;
    REVISION: string;
    AGE: string;
    'PORT(S)': string;
    SUBOBJECT: string;
};
export declare const cssForKey: {
    NAME: string;
    SOURCE: string;
    SUBOBJECT: string;
    MESSAGE: string;
    'CREATED AT': string;
    AGE: string;
    'APP VERSION': string;
    UPDATED: string;
};
export declare const tagForKey: {
    REASON: string;
    Reason: string;
    STATUS: string;
    Status: string;
};
export declare const tagsForKind: {
    Deployment: {
        READY: string;
        Ready: string;
    };
};
/**
 * Split the given string at the given split indices
 *
 */
export interface Pair {
    key: string;
    value: string;
}
/**
 * Find the column splits
 *
 */
export declare const preprocessTable: (raw: string[]) => Pair[][][];
/**
 * Interpret READY column value "n/m" as a traffic light based on
 * whehter n/m === 1.
 *
 */
export declare function cssForReadyCount(ready: string): string;
/** @return a namespace breadcrumb, either from the one given by args, or using the default from context */
export declare function getNamespaceBreadcrumbs(entityType: string, args: Pick<Arguments<KubeOptions>, 'parsedOptions' | 'execOptions' | 'REPL'>): Promise<Breadcrumb[]>;
/** HELLO -> Hello, which is not possible to do with CSS */
export declare function initialCapital(name: string): string;
export declare const formatTable: <O extends KubeOptions>(command: string, verb: string, entityTypeFromCommandLine: string, args: Arguments<O>, preTable: Pair[][], nameColumn?: string) => Promise<Table>;
export declare type KubeTableResponse = Table | MixedResponse | string;
export declare function isKubeTableResponse(response: KubeTableResponse | RawResponse): response is KubeTableResponse;
export declare function withNotFound(table: Table, stderr: string): Table<Row>;
/**
 * Display the given string as a REPL table
 *
 */
export declare const stringToTable: <O extends KubeOptions>(decodedResult: string, stderr: string, args: Arguments<O>, command?: string, verb?: string, entityType?: string, nameColumn?: string) => Promise<KubeTableResponse>;
/**
 * Turn START and END columns into a DURATION column.
 *
 * TODO Kubectl gurus: Is there a way to get this directly from a
 * jsonpath or go-template?  I think so from the latter?
 *
 */
export declare function computeDurations<T extends Table | KResponse>(table: T): T;
/** Change the namespace breadcrumb of the given maybe-Table */
export declare function withNamespaceBreadcrumb(ns: string, table: Table | MixedResponse): Table<Row> | MixedResponse;
/** Don't hide this attribute with the sidecar open */
export declare function showAlways(attr: number | string, table: Table): void;
/** Don't show this attribute with the sidecar open */
export declare function hideWithSidecar(attr: number | string, table: Table): void;
export declare function rowKeyFor(metadata: KubeResource['metadata'], kind: string): string;
export declare function toKuiTable(table: MetaTable, kind: string, args: Pick<Arguments<KubeOptions>, 'parsedOptions' | 'execOptions' | 'REPL'>, drilldownCommand: string, needsStatusColumn?: boolean, customColumns?: string[]): Table;
