/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { i18n, encodeComponent } from '@kui-shell/core';
import { isCustomResourceDefinition } from '../../model/resource';
import { fqn, getCommandFromArgs, getCurrentDefaultNamespace } from '../../..';
const strings = i18n('plugin-kubectl');
/**
 * Extract the events
 *
 */
export function command(tab, crd, args) {
    return __awaiter(this, void 0, void 0, function* () {
        return `${getCommandFromArgs(args)} get ${fqn(crd.apiVersion, encodeComponent(crd.kind), encodeComponent(crd.metadata.name), encodeComponent(crd.metadata.namespace || (yield getCurrentDefaultNamespace(tab))))}`;
    });
}
/**
 * Add a Events mode button to the given modes model, if called for by
 * the given resource.
 *
 */
const mode = {
    when: isCustomResourceDefinition,
    mode: {
        mode: 'show-crd-resources',
        label: strings('Show Resources'),
        command,
        kind: 'drilldown'
    }
};
export default mode;
//# sourceMappingURL=show-crd-managed-resources.js.map