/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors, Util } from '@kui-shell/test';
import { waitForRed, createNS, allocateNS, deleteNS, openSidecarByList } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
import { dirname } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubectl/tests/package.json'));
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
commands.forEach(command => {
    describe(`${command} apply crd ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        const crdName = 'crontabs.stable.example.com';
        const kind = 'CustomResourceDefinition';
        allocateNS(this, ns, command);
        let res;
        it(`should create custom resource definition from file via "${command} apply -f"`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                res = yield openSidecarByList(this, `${command} apply -f ${ROOT}/data/k8s/crd.yaml ${inNamespace}`, crdName).then(SidecarExpect.yaml({ Kind: 'CronTab' }));
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        it(`should switch to last applied tab of custom resource definitions`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                // make sure we have a last applied tab
                console.error(`${command} apply crd 4`);
                yield Util.switchToTab('last applied')(res);
                let idx = 0;
                console.error(`${command} apply crd 5`);
                yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                    const text = yield Util.getValueFromMonaco(res);
                    if (++idx > 5) {
                        console.error(`still waiting for yaml in ${this.title}`, text);
                    }
                    return Promise.resolve(text)
                        .then(Util.expectYAMLSubset({
                        apiVersion: 'apiextensions.k8s.io/v1beta1',
                        kind: 'CustomResourceDefinition',
                        metadata: {
                            name: crdName
                        }
                    }, false))
                        .catch(() => false);
                }));
                console.error(`${command} apply crd 6`);
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        it('should open crd in sidecar, then click on Show Resources button', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const res = yield CLI.command(`${command} get ${kind} -n ${ns} ${crdName} -o yaml`, this.app);
                console.error(`${command} apply crd 7`);
                yield Promise.resolve(res)
                    .then(ReplExpect.ok)
                    .then(SidecarExpect.open)
                    .then(SidecarExpect.showing(crdName))
                    .catch(Common.oops(this, true));
                yield this.app.client.$(Selectors.SIDECAR_MODE_BUTTON(res.count, 'show-crd-resources')).then((_) => __awaiter(this, void 0, void 0, function* () {
                    yield _.waitForDisplayed();
                    yield _.click();
                }));
                yield Promise.resolve({ app: this.app, count: res.count + 1 }).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(crdName) }));
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
        it(`should delete the custom resource definition from URL via ${command}`, () => {
            return CLI.command(`${command} delete -f ${ROOT}/data/k8s/crd.yaml ${inNamespace}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(crdName) }))
                .then(selector => waitForRed(this.app, selector))
                .catch(Common.oops(this, true));
        });
        deleteNS(this, ns, command);
    });
});
//# sourceMappingURL=apply-crd.js.map