"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = registerOcProjectGet;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

// we use the fetcher from 'kubectl get', and the viewTransformer from 'kubectl get namespaces'
function registerOcProjectGet(registrar) {
  registrar.listen('/oc/project', args => __awaiter(this, void 0, void 0, function* () {
    const response = yield (0, _pluginKubectl.doExecWithStdout)(args, undefined, 'oc');
    const newNamespace = args.argvNoOptions[args.argvNoOptions.indexOf('project') + 1];

    if (newNamespace) {
      (0, _pluginKubectl.emitKubectlConfigChangeEvent)('SetNamespaceOrContext', newNamespace);
    }

    return response;
  }));
  registrar.listen('/oc/projects', args => args.REPL.qexec('oc get projects', undefined, undefined, args.execOptions), _pluginKubectl.defaultFlags);
  const aliases = ['project', 'projects', 'ns', 'namespace', 'namespaces'];
  aliases.forEach(ns => {
    registrar.listen(`/oc/get/${ns}`, (0, _pluginKubectl.doGet)('oc'), _pluginKubectl.defaultFlags);
  });
}