import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["align", "open", "count", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { ChevronRight16 } from '@carbon/icons-react';
import SkeletonText from '../SkeletonText';
import deprecate from '../../prop-types/deprecate';
import { usePrefix } from '../../internal/usePrefix';

function AccordionSkeleton(_ref) {
  var align = _ref.align,
      open = _ref.open,
      count = _ref.count,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var classes = cx("".concat(prefix, "--accordion"), "".concat(prefix, "--skeleton"), className, _defineProperty({}, "".concat(prefix, "--accordion--").concat(align), align));
  var numSkeletonItems = open ? count - 1 : count;
  return /*#__PURE__*/React.createElement("ul", _extends({
    className: classes
  }, rest), open && /*#__PURE__*/React.createElement("li", {
    className: "".concat(prefix, "--accordion__item ").concat(prefix, "--accordion__item--active")
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--accordion__heading")
  }, /*#__PURE__*/React.createElement(ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    className: "".concat(prefix, "--accordion__title")
  })), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--accordion__content")
  }, /*#__PURE__*/React.createElement(SkeletonText, {
    width: "90%"
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    width: "80%"
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    width: "95%"
  }))), Array.from({
    length: numSkeletonItems
  }).map(function (_, i) {
    return /*#__PURE__*/React.createElement(AccordionSkeletonItem, {
      key: i
    });
  }));
}

AccordionSkeleton.propTypes = {
  /**
   * Specify the alignment of the accordion heading title and chevron.
   */
  align: PropTypes.oneOf(['start', 'end']),

  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * Set number of items to render
   */
  count: PropTypes.number,

  /**
   * `false` to not display the first item opened
   */
  open: PropTypes.bool,

  /**
   * Set unique identifier to generate unique item keys
   */
  uid: deprecate(PropTypes.any)
};
AccordionSkeleton.defaultProps = {
  open: true,
  count: 4,
  align: 'end'
};

function AccordionSkeletonItem() {
  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("li", {
    className: "".concat(prefix, "--accordion__item")
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--accordion__heading")
  }, /*#__PURE__*/React.createElement(ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    className: "".concat(prefix, "--accordion__title")
  })));
}

export default AccordionSkeleton;