/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { Add16 } from '@carbon/icons-react';
import { default as Button, ButtonSkeleton } from '../';
import ButtonSet from '../../ButtonSet';
export default {
  title: 'Components/Button',
  parameters: {
    component: Button,
    subcomponents: {
      ButtonSet: ButtonSet,
      ButtonSkeleton: ButtonSkeleton
    }
  }
};
export var _Default = function _Default() {
  return /*#__PURE__*/React.createElement(Button, null, "Button");
};
export var Secondary = function Secondary() {
  return /*#__PURE__*/React.createElement(Button, {
    kind: "secondary"
  }, "Button");
};
export var Tertiary = function Tertiary() {
  return /*#__PURE__*/React.createElement(Button, {
    kind: "tertiary"
  }, "Button");
};
export var Danger = function Danger() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Button, {
    kind: "danger"
  }, "Button"), "\xA0", /*#__PURE__*/React.createElement(Button, {
    kind: "danger--tertiary"
  }, "Tertiary Danger Button"), "\xA0", /*#__PURE__*/React.createElement(Button, {
    kind: "danger--ghost"
  }, "Ghost Danger Button"));
};
export var Ghost = function Ghost() {
  return /*#__PURE__*/React.createElement(Button, {
    kind: "ghost"
  }, "Button");
};
export var IconButton = function IconButton() {
  return /*#__PURE__*/React.createElement(Button, {
    renderIcon: Add16,
    iconDescription: "Icon Description",
    hasIconOnly: true,
    onClick: action('onClick')
  });
};
export var SetOfButtons = function SetOfButtons() {
  return /*#__PURE__*/React.createElement(ButtonSet, null, /*#__PURE__*/React.createElement(Button, {
    kind: "secondary"
  }, "Secondary button"), /*#__PURE__*/React.createElement(Button, {
    kind: "primary"
  }, "Primary button"));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(ButtonSkeleton, null), "\xA0", /*#__PURE__*/React.createElement(ButtonSkeleton, {
    small: true
  }));
};