/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import 'carbon-components/scss/components/button/_button.scss';
import React from 'react';
import { mount } from '@cypress/react';
import { default as Button } from '../Button';
import { default as ButtonSet } from './ButtonSet';
describe('ButtonSet', function () {
  beforeEach(function () {
    mount( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(ButtonSet, null, /*#__PURE__*/React.createElement(Button, {
      kind: "secondary"
    }, "set-secondary"), /*#__PURE__*/React.createElement(Button, {
      kind: "primary"
    }, "set-primary")), /*#__PURE__*/React.createElement(ButtonSet, {
      stacked: true
    }, /*#__PURE__*/React.createElement(Button, {
      kind: "secondary"
    }, "set-stacked-secondary"), /*#__PURE__*/React.createElement(Button, {
      kind: "primary"
    }, "set-stacked-primary")), /*#__PURE__*/React.createElement(ButtonSet, null, /*#__PURE__*/React.createElement(Button, {
      kind: "secondary",
      isExpressive: true
    }, "set-secondary-expressive"), /*#__PURE__*/React.createElement(Button, {
      kind: "primary",
      isExpressive: true
    }, "set-primary-expressive"))));
  });
  it('should render', function () {
    // full string match regex syntax ^string$ to prevent collisions
    cy.findByText(/^set-secondary$/).should('be.visible');
    cy.findByText(/^set-primary$/).should('be.visible');
    cy.findByText(/^set-stacked-secondary$/).should('be.visible');
    cy.findByText(/^set-stacked-primary$/).should('be.visible');
    cy.findByText(/^set-secondary-expressive$/).should('be.visible');
    cy.findByText(/^set-primary-expressive$/).should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});