import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _regeneratorRuntime from "@babel/runtime/regenerator";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import Checkbox from '../Checkbox';
import CheckboxSkeleton from '../Checkbox/Checkbox.Skeleton';
import { mount } from 'enzyme';
import { settings } from 'carbon-components';
import { cleanup, render, screen } from '@testing-library/react';
import userEvent from '@testing-library/user-event';
var prefix = settings.prefix;
describe('Checkbox', function () {
  describe('Renders as expected', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Checkbox, {
      id: "testing",
      labelText: "testingLabel",
      className: "extra-class"
    }));
    var label = wrapper.find('label');
    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });
      it('has the expected classes', function () {
        expect(label.hasClass("".concat(prefix, "--checkbox-label"))).toEqual(true);
      });
      it('has the expected htmlFor value', function () {
        expect(label.props().htmlFor).toEqual('testing');
      });
      it('applies extra classes to label', function () {
        expect(label.hasClass('extra-class')).toEqual(true);
      });
      describe('input', function () {
        var input = function input() {
          return wrapper.find('input');
        };

        it('has id set as expected', function () {
          expect(input().props().id).toEqual('testing');
        });
        it('defaultChecked prop sets defaultChecked on input', function () {
          expect(input().props().defaultChecked).toBeUndefined();
          wrapper.setProps({
            defaultChecked: true
          });
          expect(input().props().defaultChecked).toEqual(true);
        });
      });
    });
  });
  it('disabled prop on component sets disabled prop on input', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Checkbox, {
      id: "test",
      labelText: "testlabel",
      disabled: true
    }));

    var input = function input() {
      return wrapper.find('input');
    };

    expect(input().props().disabled).toEqual(true);
    wrapper.setProps({
      disabled: false
    });
    expect(input().props().disabled).toEqual(false);
  });
  it('checked prop on component sets checked prop on input', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Checkbox, {
      id: "test",
      labelText: "testlabel",
      checked: true
    }));

    var input = function input() {
      return wrapper.find('input');
    };

    expect(input().props().checked).toEqual(true);
    wrapper.setProps({
      checked: false
    });
    expect(input().props().checked).toEqual(false);
  });
  it('hideLabel hides the label visually', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Checkbox, {
      id: "test",
      labelText: "testlabel",
      hideLabel: true
    }));
    var label = wrapper.find('label');
    expect(label.length).toEqual(1);
    var span = wrapper.find('span');
    expect(span.hasClass("".concat(prefix, "--visually-hidden"))).toEqual(true);
  });
  describe('events', function () {
    it('should invoke onChange with expected arguments', function () {
      var onChange = jest.fn();
      var id = 'test-input';
      var wrapper = mount( /*#__PURE__*/React.createElement(Checkbox, {
        labelText: "testlabel",
        id: id,
        onChange: onChange
      }));
      var input = wrapper.find('input');
      var inputElement = input.instance();
      inputElement.checked = true;
      wrapper.find('input').simulate('change');
      var call = onChange.mock.calls[0];
      expect(call[0]).toEqual(true);
      expect(call[1]).toEqual(id);
      expect(call[2].target).toBe(inputElement);
    });
  });
});
describe('refs', function () {
  var container;
  afterEach(function () {
    if (container && container.parentNode) {
      container.parentNode.removeChild(container);
    }

    container = null;
  });
  it('should accept refs', function () {
    var MyComponent = /*#__PURE__*/function (_React$Component) {
      _inherits(MyComponent, _React$Component);

      var _super = _createSuper(MyComponent);

      function MyComponent(props) {
        var _this;

        _classCallCheck(this, MyComponent);

        _this = _super.call(this, props);
        _this.myRef = /*#__PURE__*/React.createRef();
        _this.focus = _this.focus.bind(_assertThisInitialized(_this));
        return _this;
      }

      _createClass(MyComponent, [{
        key: "focus",
        value: function focus() {
          this.myRef.current.focus();
        }
      }, {
        key: "render",
        value: function render() {
          return /*#__PURE__*/React.createElement(Checkbox, {
            id: "test",
            labelText: "testlabel",
            hideLabel: true,
            ref: this.myRef
          });
        }
      }]);

      return MyComponent;
    }(React.Component);

    container = document.createElement('div');
    container.id = 'container';
    document.body.appendChild(container);
    var wrapper = mount( /*#__PURE__*/React.createElement(MyComponent, null), {
      attachTo: document.querySelector('#container')
    });
    expect(document.activeElement.type).toBeUndefined();
    wrapper.instance().focus();
    expect(document.activeElement.type).toEqual('checkbox');
  });
  it('should set indeterminate when accepting refs', function () {
    var MyComponent = /*#__PURE__*/function (_React$Component2) {
      _inherits(MyComponent, _React$Component2);

      var _super2 = _createSuper(MyComponent);

      function MyComponent(props) {
        var _this2;

        _classCallCheck(this, MyComponent);

        _this2 = _super2.call(this, props);
        _this2.myRef = /*#__PURE__*/React.createRef();
        return _this2;
      }

      _createClass(MyComponent, [{
        key: "render",
        value: function render() {
          return /*#__PURE__*/React.createElement(Checkbox, {
            id: "test-id",
            labelText: "test",
            indeterminate: true,
            ref: this.myRef
          });
        }
      }]);

      return MyComponent;
    }(React.Component);

    var wrapper = mount( /*#__PURE__*/React.createElement(MyComponent, null));
    expect(wrapper.find('input').getDOMNode().indeterminate).toBe(true);
  });
});
describe('CheckboxSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(CheckboxSkeleton, null));
    var label = wrapper.find('span');
    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });
      it('has the expected classes', function () {
        expect(label.hasClass("".concat(prefix, "--checkbox-label-text"))).toEqual(true);
        expect(label.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
      });
    });
  });
});
describe('Checkbox accessibility', function () {
  afterEach(cleanup);
  it('should have no Axe violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            render( /*#__PURE__*/React.createElement(Checkbox, {
              labelText: "Checkbox label",
              id: "test_id"
            }));
            _context.next = 3;
            return expect(screen.getByLabelText('Checkbox label')).toHaveNoAxeViolations();

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
  it('should have no Accessibility Checker violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            render( /*#__PURE__*/React.createElement("main", null, /*#__PURE__*/React.createElement(Checkbox, {
              labelText: "Checkbox label",
              id: "test_id"
            })));
            _context2.next = 3;
            return expect(screen.getByLabelText('Checkbox label')).toHaveNoACViolations('Checkbox');

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  })));
  it('can receive keyboard focus', function () {
    render( /*#__PURE__*/React.createElement(Checkbox, {
      labelText: "Checkbox label",
      id: "test_id"
    }));
    userEvent.tab();
    expect(screen.getByLabelText('Checkbox label')).toHaveFocus();
  });
  it('should have an accessible label', function () {
    render( /*#__PURE__*/React.createElement(Checkbox, {
      labelText: "Checkbox label",
      id: "test_id"
    }));
    expect(function () {
      return screen.getByText('Checkbox label');
    }).not.toThrow();
  });
  it('should have an appropriate role', function () {
    render( /*#__PURE__*/React.createElement(Checkbox, {
      labelText: "Checkbox label",
      id: "test_id"
    }));
    expect(function () {
      return screen.getByRole('checkbox');
    }).not.toThrow();
  });
});