/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { default as Checkbox, CheckboxSkeleton } from '../';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
export default {
  title: 'Components/Checkbox',
  component: Checkbox,
  subcomponents: {
    CheckboxSkeleton: CheckboxSkeleton
  }
};
export var checkbox = function checkbox() {
  return /*#__PURE__*/React.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/React.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), /*#__PURE__*/React.createElement(Checkbox, {
    labelText: "Checkbox label",
    id: "checkbox-label-1"
  }), /*#__PURE__*/React.createElement(Checkbox, {
    labelText: "Checkbox label",
    id: "checkbox-label-2"
  }));
};
export var skeleton = function skeleton() {
  return /*#__PURE__*/React.createElement(CheckboxSkeleton, null);
};