import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "type"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { usePrefix } from '../../internal/usePrefix';

function CodeSnippetSkeleton(_ref) {
  var _cx;

  var containerClassName = _ref.className,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'single' : _ref$type,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var className = cx(containerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--snippet"), true), _defineProperty(_cx, "".concat(prefix, "--skeleton"), true), _defineProperty(_cx, "".concat(prefix, "--snippet--single"), type === 'single'), _defineProperty(_cx, "".concat(prefix, "--snippet--multi"), type === 'multi'), _cx));

  if (type === 'single') {
    return /*#__PURE__*/React.createElement("div", _extends({
      className: className
    }, rest), /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--snippet-container")
    }, /*#__PURE__*/React.createElement("span", null)));
  }

  if (type === 'multi') {
    return /*#__PURE__*/React.createElement("div", _extends({
      className: className
    }, rest), /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--snippet-container")
    }, /*#__PURE__*/React.createElement("span", null), /*#__PURE__*/React.createElement("span", null), /*#__PURE__*/React.createElement("span", null)));
  }
}

CodeSnippetSkeleton.propTypes = {
  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * The type of the code snippet, including single or multi
   */
  type: PropTypes.oneOf(['single', 'multi'])
};
export default CodeSnippetSkeleton;