import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

var _ModalBody$propTypes, _ComposedModal$propTy;

var _excluded = ["className", "children", "hasForm", "hasScrollingContent"],
    _excluded2 = ["aria-labelledby", "aria-label", "children", "className", "containerClassName", "danger", "onClose", "onKeyDown", "open", "preventCloseOnClickOutside", "selectorPrimaryFocus", "selectorsFloatingMenus", "size"];
import React, { useRef, useEffect, useState } from 'react';
import PropTypes from 'prop-types';
import { ModalHeader } from './ModalHeader';
import { ModalFooter } from '../ComposedModal';
import cx from 'classnames';
import toggleClass from '../../../tools/toggleClass';
import requiredIfGivenPropIsTruthy from '../../../prop-types/requiredIfGivenPropIsTruthy';
import wrapFocus from '../../../internal/wrapFocus';
import { usePrefix } from '../../../internal/usePrefix';
export function ModalBody(_ref) {
  var _cx;

  var customClassName = _ref.className,
      children = _ref.children,
      hasForm = _ref.hasForm,
      hasScrollingContent = _ref.hasScrollingContent,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var contentClass = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--modal-content"), true), _defineProperty(_cx, "".concat(prefix, "--modal-content--with-form"), hasForm), _defineProperty(_cx, "".concat(prefix, "--modal-scroll-content"), hasScrollingContent), _defineProperty(_cx, customClassName, customClassName), _cx));
  var hasScrollingContentProps = hasScrollingContent ? {
    tabIndex: 0,
    role: 'region'
  } : {};
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", _extends({
    className: contentClass
  }, hasScrollingContentProps, rest), children), hasScrollingContent && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--modal-content--overflow-indicator")
  }));
}
ModalBody.propTypes = (_ModalBody$propTypes = {}, _defineProperty(_ModalBody$propTypes, 'aria-label', requiredIfGivenPropIsTruthy('hasScrollingContent', PropTypes.string)), _defineProperty(_ModalBody$propTypes, "children", PropTypes.node), _defineProperty(_ModalBody$propTypes, "className", PropTypes.string), _defineProperty(_ModalBody$propTypes, "hasForm", PropTypes.bool), _defineProperty(_ModalBody$propTypes, "hasScrollingContent", PropTypes.bool), _ModalBody$propTypes);
var ComposedModal = /*#__PURE__*/React.forwardRef(function ComposedModal(_ref2, ref) {
  var _cx2, _cx3;

  var ariaLabelledBy = _ref2['aria-labelledby'],
      ariaLabel = _ref2['aria-label'],
      children = _ref2.children,
      customClassName = _ref2.className,
      containerClassName = _ref2.containerClassName,
      danger = _ref2.danger,
      onClose = _ref2.onClose,
      onKeyDown = _ref2.onKeyDown,
      open = _ref2.open,
      preventCloseOnClickOutside = _ref2.preventCloseOnClickOutside,
      selectorPrimaryFocus = _ref2.selectorPrimaryFocus,
      selectorsFloatingMenus = _ref2.selectorsFloatingMenus,
      size = _ref2.size,
      rest = _objectWithoutProperties(_ref2, _excluded2);

  var prefix = usePrefix();

  var _useState = useState(open),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setisOpen = _useState2[1];

  var _useState3 = useState(open),
      _useState4 = _slicedToArray(_useState3, 2),
      prevOpen = _useState4[0],
      setPrevOpen = _useState4[1];

  var innerModal = useRef();
  var button = useRef();
  var startSentinel = useRef();
  var endSentinel = useRef();

  if (open !== prevOpen) {
    setisOpen(open);
    setPrevOpen(open);
  }

  function handleKeyDown(evt) {
    // Esc key
    if (evt.which === 27) {
      closeModal(evt);
    }

    onKeyDown(evt);
  }

  function handleClick(evt) {
    if (!innerModal.current.contains(evt.target) && preventCloseOnClickOutside) {
      return;
    }

    if (innerModal.current && !innerModal.current.contains(evt.target)) {
      closeModal(evt);
    }
  }

  function handleBlur(_ref3) {
    var oldActiveNode = _ref3.target,
        currentActiveNode = _ref3.relatedTarget;

    if (open && currentActiveNode && oldActiveNode) {
      var bodyNode = innerModal.current;
      var startSentinelNode = startSentinel.current;
      var endSentinelNode = endSentinel.current;
      wrapFocus({
        bodyNode: bodyNode,
        startSentinelNode: startSentinelNode,
        endSentinelNode: endSentinelNode,
        currentActiveNode: currentActiveNode,
        oldActiveNode: oldActiveNode,
        selectorsFloatingMenus: selectorsFloatingMenus
      });
    }
  }

  function closeModal(evt) {
    if (!onClose || onClose(evt) !== false) {
      setisOpen(false);
    }
  }

  var modalClass = cx((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--modal"), true), _defineProperty(_cx2, 'is-visible', isOpen), _defineProperty(_cx2, customClassName, customClassName), _defineProperty(_cx2, "".concat(prefix, "--modal--danger"), danger), _cx2));
  var containerClass = cx((_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--modal-container"), true), _defineProperty(_cx3, "".concat(prefix, "--modal-container--").concat(size), size), _defineProperty(_cx3, containerClassName, containerClassName), _cx3)); // Generate aria-label based on Modal Header label if one is not provided (L253)

  var generatedAriaLabel;
  var childrenWithProps = React.Children.toArray(children).map(function (child) {
    switch (child.type) {
      case /*#__PURE__*/React.createElement(ModalHeader).type:
        generatedAriaLabel = child.props.label;
        return /*#__PURE__*/React.cloneElement(child, {
          closeModal: closeModal
        });

      case /*#__PURE__*/React.createElement(ModalFooter).type:
        return /*#__PURE__*/React.cloneElement(child, {
          closeModal: closeModal,
          inputref: button
        });

      default:
        return child;
    }
  });
  useEffect(function () {
    if (prevOpen !== isOpen) {
      toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), isOpen);
    }
  });
  useEffect(function () {
    return function () {
      return toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), false);
    };
  });
  useEffect(function () {
    toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), open);
  }, [open, prefix]);
  useEffect(function () {
    var focusButton = function focusButton(focusContainerElement) {
      if (focusContainerElement) {
        var primaryFocusElement = focusContainerElement.querySelector(selectorPrimaryFocus);

        if (primaryFocusElement) {
          primaryFocusElement.focus();
          return;
        }

        if (button.current) {
          button.current.focus();
        }
      }
    };

    if (!open) {
      return;
    }

    if (innerModal.current) {
      focusButton(innerModal.current);
    }
  }, [open, selectorPrimaryFocus]);
  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    role: "presentation",
    ref: ref,
    onBlur: handleBlur,
    onClick: handleClick,
    onKeyDown: handleKeyDown,
    className: modalClass
  }), /*#__PURE__*/React.createElement("span", {
    ref: startSentinel,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"), /*#__PURE__*/React.createElement("div", {
    ref: innerModal,
    className: containerClass,
    role: "dialog",
    "aria-modal": "true",
    "aria-label": ariaLabel ? ariaLabel : generatedAriaLabel,
    "aria-labelledby": ariaLabelledBy
  }, childrenWithProps), /*#__PURE__*/React.createElement("span", {
    ref: endSentinel,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"));
});
ComposedModal.propTypes = (_ComposedModal$propTy = {}, _defineProperty(_ComposedModal$propTy, 'aria-label', PropTypes.string), _defineProperty(_ComposedModal$propTy, 'aria-labelledby', PropTypes.string), _defineProperty(_ComposedModal$propTy, "children", PropTypes.node), _defineProperty(_ComposedModal$propTy, "className", PropTypes.string), _defineProperty(_ComposedModal$propTy, "containerClassName", PropTypes.string), _defineProperty(_ComposedModal$propTy, "danger", PropTypes.bool), _defineProperty(_ComposedModal$propTy, "onClose", PropTypes.func), _defineProperty(_ComposedModal$propTy, "onKeyDown", PropTypes.func), _defineProperty(_ComposedModal$propTy, "open", PropTypes.bool), _defineProperty(_ComposedModal$propTy, "preventCloseOnClickOutside", PropTypes.bool), _defineProperty(_ComposedModal$propTy, "selectorPrimaryFocus", PropTypes.string), _defineProperty(_ComposedModal$propTy, "selectorsFloatingMenus", PropTypes.string), _defineProperty(_ComposedModal$propTy, "size", PropTypes.oneOf(['xs', 'sm', 'md', 'lg'])), _ComposedModal$propTy);
ComposedModal.defaultProps = {
  onKeyDown: function onKeyDown() {},
  selectorPrimaryFocus: '[data-modal-primary-focus]'
};
export default ComposedModal;