/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { render, cleanup } from '@testing-library/react';
import { ModalHeader } from './ModalHeader';
describe('ModalHeader', function () {
  afterEach(cleanup);
  it('should render title if has title text', function () {
    var _render = render( /*#__PURE__*/React.createElement(ModalHeader, {
      title: "Carbon"
    })),
        container = _render.container;

    expect(container.firstChild).toHaveTextContent('Carbon');
  });
  it('should label if has label text', function () {
    var _render2 = render( /*#__PURE__*/React.createElement(ModalHeader, {
      label: "Carbon label"
    })),
        container = _render2.container;

    expect(container.firstChild).toHaveTextContent('Carbon label');
  });
});