import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "light", "selectedIndex", "selectionMode", "size"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import deprecate from '../../prop-types/deprecate';
import { composeEventHandlers } from '../../tools/events';
import { getNextIndex, matches, keys } from '../../internal/keyboard';
import { PrefixContext } from '../../internal/usePrefix';

var ContentSwitcher = /*#__PURE__*/function (_React$Component) {
  _inherits(ContentSwitcher, _React$Component);

  var _super = _createSuper(ContentSwitcher);

  function ContentSwitcher() {
    var _this;

    _classCallCheck(this, ContentSwitcher);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "_switchRefs", []);

    _defineProperty(_assertThisInitialized(_this), "state", {});

    _defineProperty(_assertThisInitialized(_this), "handleItemRef", function (index) {
      return function (ref) {
        _this._switchRefs[index] = ref;
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleChildChange", function (data) {
      var selectionMode = _this.props.selectionMode; // the currently selected child index

      var selectedIndex = _this.state.selectedIndex; // the newly selected child index

      var index = data.index;
      var key = data.key;

      if (matches(data, [keys.ArrowRight, keys.ArrowLeft])) {
        var nextIndex = getNextIndex(key, index, _this.props.children.length);
        var children = React.Children.toArray(_this.props.children);

        if (selectionMode === 'manual') {
          var switchRef = _this._switchRefs[nextIndex];
          switchRef && switchRef.focus();
        } else {
          _this.setState({
            selectedIndex: nextIndex
          }, function () {
            var child = children[_this.state.selectedIndex];
            var switchRef = _this._switchRefs[_this.state.selectedIndex];
            switchRef && switchRef.focus();

            _this.props.onChange(_objectSpread(_objectSpread({}, data), {}, {
              index: _this.state.selectedIndex,
              name: child.props.name,
              text: child.props.text
            }));
          });
        }
      } else if (selectedIndex !== index) {
        _this.setState({
          selectedIndex: index
        }, function () {
          var switchRef = _this._switchRefs[index];
          switchRef && switchRef.focus();

          _this.props.onChange(data);
        });
      }
    });

    return _this;
  }

  _createClass(ContentSwitcher, [{
    key: "render",
    value: function render() {
      var _classNames,
          _this2 = this;

      var prefix = this.context;

      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          light = _this$props.light,
          selectedIndex = _this$props.selectedIndex,
          selectionMode = _this$props.selectionMode,
          size = _this$props.size,
          other = _objectWithoutProperties(_this$props, _excluded);

      var classes = classNames("".concat(prefix, "--content-switcher"), className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--content-switcher--light"), light), _defineProperty(_classNames, "".concat(prefix, "--content-switcher--").concat(size), size), _classNames));
      return /*#__PURE__*/React.createElement("div", _extends({}, other, {
        className: classes,
        role: "tablist"
      }), React.Children.map(children, function (child, index) {
        return /*#__PURE__*/React.cloneElement(child, {
          index: index,
          onClick: composeEventHandlers([_this2.handleChildChange, child.props.onClick]),
          onKeyDown: _this2.handleChildChange,
          selected: index === _this2.state.selectedIndex,
          ref: _this2.handleItemRef(index)
        });
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var selectedIndex = _ref.selectedIndex;
      var prevSelectedIndex = state.prevSelectedIndex;
      return prevSelectedIndex === selectedIndex ? null : {
        selectedIndex: selectedIndex,
        prevSelectedIndex: selectedIndex
      };
    }
  }]);

  return ContentSwitcher;
}(React.Component);

_defineProperty(ContentSwitcher, "propTypes", {
  /**
   * Pass in Switch components to be rendered in the ContentSwitcher
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be added to the container node
   */
  className: PropTypes.string,

  /**
   * `true` to use the light variant.
   */
  light: deprecate(PropTypes.bool, 'The `light` prop for `ContentSwitcher` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

  /**
   * Specify an `onChange` handler that is called whenever the ContentSwitcher
   * changes which item is selected
   */
  onChange: PropTypes.func.isRequired,

  /**
   * Specify a selected index for the initially selected content
   */
  selectedIndex: PropTypes.number,

  /**
   * Choose whether or not to automatically change selection on focus
   */
  selectionMode: PropTypes.oneOf(['automatic', 'manual']),

  /**
   * Specify the size of the Content Switcher. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg', 'xl'])
});

_defineProperty(ContentSwitcher, "contextType", PrefixContext);

_defineProperty(ContentSwitcher, "defaultProps", {
  selectedIndex: 0,
  selectionMode: 'automatic',
  onChange: function onChange() {}
});

export { ContentSwitcher as default };