import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "feedback", "feedbackTimeout", "onAnimationEnd", "onClick"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useState, useEffect, useCallback } from 'react';
import debounce from 'lodash.debounce';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import { composeEventHandlers } from '../../tools/events';
var prefix = settings.prefix;
export default function Copy(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      feedback = _ref.feedback,
      feedbackTimeout = _ref.feedbackTimeout,
      onAnimationEnd = _ref.onAnimationEnd,
      onClick = _ref.onClick,
      other = _objectWithoutProperties(_ref, _excluded);

  var _useState = useState(''),
      _useState2 = _slicedToArray(_useState, 2),
      animation = _useState2[0],
      setAnimation = _useState2[1];

  var classNames = classnames(className, "".concat(prefix, "--copy"), (_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--copy-btn--animating"), animation), _defineProperty(_classnames, "".concat(prefix, "--copy-btn--").concat(animation), animation), _classnames)); // eslint-disable-next-line react-hooks/exhaustive-deps

  var handleFadeOut = useCallback(debounce(function () {
    setAnimation('fade-out');
  }, feedbackTimeout), [feedbackTimeout]);
  var handleClick = useCallback(function () {
    setAnimation('fade-in');
    handleFadeOut();
  }, [handleFadeOut]);

  var handleAnimationEnd = function handleAnimationEnd(event) {
    if (event.animationName === 'hide-feedback') {
      setAnimation('');
    }
  };

  useEffect(function () {
    return function () {
      handleFadeOut.cancel();
    };
  }, [handleFadeOut]);
  return /*#__PURE__*/React.createElement("button", _extends({
    type: "button",
    className: classNames,
    onClick: composeEventHandlers([onClick, handleClick]),
    onAnimationEnd: composeEventHandlers([onAnimationEnd, handleAnimationEnd])
  }, other, {
    "aria-live": "polite",
    "aria-label": !children && (animation ? feedback : other['aria-label']) || null
  }), children, animation ? feedback : other['aria-label'], /*#__PURE__*/React.createElement("span", {
    "aria-hidden": "true",
    className: "".concat(prefix, "--assistive-text ").concat(prefix, "--copy-btn__feedback")
  }, feedback));
}
Copy.propTypes = {
  /**
   * Pass in content to be rendered in the underlying `<button>`
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the underlying `<button>`
   */
  className: PropTypes.string,

  /**
   * Specify the string that is displayed when the button is clicked and the
   * content is copied
   */
  feedback: PropTypes.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: PropTypes.number,

  /**
   * Specify an optional `onAnimationEnd` handler that is called when the underlying
   * animation ends
   */
  onAnimationEnd: PropTypes.func,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * `<button>` is clicked
   */
  onClick: PropTypes.func
};
Copy.defaultProps = {
  feedback: 'Copied!',
  feedbackTimeout: 2000,
  onClick: function onClick() {}
};