import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["header", "onClick", "isSortable"],
    _excluded2 = ["onClick"],
    _excluded3 = ["row", "onClick"],
    _excluded4 = ["onClick", "row"];

var _defaultTranslations;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import isEqual from 'lodash.isequal';
import getDerivedStateFromProps from './state/getDerivedStateFromProps';
import { getNextSortState } from './state/sorting';
import { getCellId } from './tools/cells';
import denormalize from './tools/denormalize';
import { composeEventHandlers } from '../../tools/events';
import { defaultFilterRows } from './tools/filter';
import { defaultSortRow } from './tools/sorting';
import setupGetInstanceId from './tools/instanceId';
var getInstanceId = setupGetInstanceId();
var translationKeys = {
  expandRow: 'carbon.table.row.expand',
  collapseRow: 'carbon.table.row.collapse',
  expandAll: 'carbon.table.all.expand',
  collapseAll: 'carbon.table.all.collapse',
  selectAll: 'carbon.table.all.select',
  unselectAll: 'carbon.table.all.unselect',
  selectRow: 'carbon.table.row.select',
  unselectRow: 'carbon.table.row.unselect'
};
var defaultTranslations = (_defaultTranslations = {}, _defineProperty(_defaultTranslations, translationKeys.expandAll, 'Expand all rows'), _defineProperty(_defaultTranslations, translationKeys.collapseAll, 'Collapse all rows'), _defineProperty(_defaultTranslations, translationKeys.expandRow, 'Expand current row'), _defineProperty(_defaultTranslations, translationKeys.collapseRow, 'Collapse current row'), _defineProperty(_defaultTranslations, translationKeys.selectAll, 'Select all rows'), _defineProperty(_defaultTranslations, translationKeys.unselectAll, 'Unselect all rows'), _defineProperty(_defaultTranslations, translationKeys.selectRow, 'Select row'), _defineProperty(_defaultTranslations, translationKeys.unselectRow, 'Unselect row'), _defaultTranslations);

var translateWithId = function translateWithId(id) {
  return defaultTranslations[id];
};
/**
 * Data Tables are used to represent a collection of resources, displaying a
 * subset of their fields in columns, or headers. We prioritize direct updates
 * to the state of what we're rendering, so internally we end up normalizing the
 * given data and then denormalizing it when rendering.
 *
 * As a result, each part of the DataTable is accessible through look-up by id,
 * and updating the state of the single entity will cascade updates to the
 * consumer.
 */


var DataTable = /*#__PURE__*/function (_React$Component) {
  _inherits(DataTable, _React$Component);

  var _super = _createSuper(DataTable);

  function DataTable(_props) {
    var _this;

    _classCallCheck(this, DataTable);

    _this = _super.call(this, _props);

    _defineProperty(_assertThisInitialized(_this), "getHeaderProps", function (_ref) {
      var header = _ref.header,
          _onClick = _ref.onClick,
          _ref$isSortable = _ref.isSortable,
          isSortable = _ref$isSortable === void 0 ? _this.props.isSortable : _ref$isSortable,
          rest = _objectWithoutProperties(_ref, _excluded);

      var _this$state = _this.state,
          sortDirection = _this$state.sortDirection,
          sortHeaderKey = _this$state.sortHeaderKey;
      return _objectSpread(_objectSpread({}, rest), {}, {
        key: header.key,
        sortDirection: sortDirection,
        isSortable: isSortable,
        isSortHeader: sortHeaderKey === header.key,
        onClick: function onClick(event) {
          var nextSortState = getNextSortState(_this.props, _this.state, {
            key: header.key
          });

          _this.setState(nextSortState, function () {
            _onClick && _this.handleOnHeaderClick(_onClick, {
              sortHeaderKey: header.key,
              sortDirection: nextSortState.sortDirection
            })(event);
          });
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getExpandHeaderProps", function () {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          onClick = _ref2.onClick,
          rest = _objectWithoutProperties(_ref2, _excluded2);

      var t = _this.props.translateWithId;
      var _this$state2 = _this.state,
          isExpandedAll = _this$state2.isExpandedAll,
          rowIds = _this$state2.rowIds,
          rowsById = _this$state2.rowsById;
      var isExpanded = isExpandedAll || rowIds.every(function (id) {
        return rowsById[id].isExpanded;
      });
      var translationKey = !isExpanded ? translationKeys.collapseAll : translationKeys.expandAll;
      return _objectSpread(_objectSpread({}, rest), {}, {
        ariaLabel: t(translationKey),
        isExpanded: isExpanded,
        // Compose the event handlers so we don't overwrite a consumer's `onClick`
        // handler
        onExpand: composeEventHandlers([_this.handleOnExpandAll, onClick ? _this.handleOnExpandHeaderClick(onClick, {
          isExpanded: isExpanded
        }) : null])
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnHeaderClick", function (onClick, sortParams) {
      return function (e) {
        return onClick(e, sortParams);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnExpandHeaderClick", function (onClick, expandParams) {
      return function (e) {
        return onClick(e, expandParams);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "getRowProps", function (_ref3) {
      var row = _ref3.row,
          onClick = _ref3.onClick,
          rest = _objectWithoutProperties(_ref3, _excluded3);

      var t = _this.props.translateWithId;
      var translationKey = row.isExpanded ? translationKeys.collapseRow : translationKeys.expandRow;
      return _objectSpread(_objectSpread({}, rest), {}, {
        key: row.id,
        // Compose the event handlers so we don't overwrite a consumer's `onClick`
        // handler
        onExpand: composeEventHandlers([_this.handleOnExpandRow(row.id), onClick]),
        isExpanded: row.isExpanded,
        ariaLabel: t(translationKey),
        isSelected: row.isSelected,
        disabled: row.disabled
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getSelectionProps", function () {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          onClick = _ref4.onClick,
          row = _ref4.row,
          rest = _objectWithoutProperties(_ref4, _excluded4);

      var t = _this.props.translateWithId; // If we're given a row, return the selection state values for that row

      if (row) {
        var _translationKey = row.isSelected ? translationKeys.unselectRow : translationKeys.selectRow;

        return _objectSpread(_objectSpread({}, rest), {}, {
          checked: row.isSelected,
          onSelect: composeEventHandlers([_this.handleOnSelectRow(row.id), onClick]),
          id: "".concat(_this.getTablePrefix(), "__select-row-").concat(row.id),
          name: "select-row-".concat(row.id),
          ariaLabel: t(_translationKey),
          disabled: row.disabled,
          radio: _this.props.radio || null
        });
      } // Otherwise, we're working on `TableSelectAll` which handles toggling the
      // selection state of all rows.


      var rowCount = _this.state.rowIds.length;

      var selectedRowCount = _this.getSelectedRows().length;

      var checked = rowCount > 0 && selectedRowCount === rowCount;
      var indeterminate = rowCount > 0 && selectedRowCount > 0 && selectedRowCount !== rowCount;
      var translationKey = checked || indeterminate ? translationKeys.unselectAll : translationKeys.selectAll;
      return _objectSpread(_objectSpread({}, rest), {}, {
        ariaLabel: t(translationKey),
        checked: checked,
        id: "".concat(_this.getTablePrefix(), "__select-all"),
        indeterminate: indeterminate,
        name: 'select-all',
        onSelect: composeEventHandlers([_this.handleSelectAll, onClick])
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getToolbarProps", function () {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var size = _this.props.size; // Remove compact, short in V11

      var isSmall = size === 'compact' || size === 'short' || size === 'xs' || size === 'sm';
      return _objectSpread(_objectSpread({}, props), {}, {
        size: isSmall ? 'small' : 'normal'
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getBatchActionProps", function () {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var shouldShowBatchActions = _this.state.shouldShowBatchActions;

      var totalSelected = _this.getSelectedRows().length;

      return _objectSpread(_objectSpread({}, props), {}, {
        shouldShowBatchActions: shouldShowBatchActions && totalSelected > 0,
        totalSelected: totalSelected,
        onCancel: _this.handleOnCancel
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getTableProps", function () {
      var _this$props = _this.props,
          useZebraStyles = _this$props.useZebraStyles,
          size = _this$props.size,
          isSortable = _this$props.isSortable,
          useStaticWidth = _this$props.useStaticWidth,
          shouldShowBorder = _this$props.shouldShowBorder,
          stickyHeader = _this$props.stickyHeader,
          overflowMenuOnHover = _this$props.overflowMenuOnHover;
      return {
        useZebraStyles: useZebraStyles,
        size: size,
        isSortable: isSortable,
        useStaticWidth: useStaticWidth,
        shouldShowBorder: shouldShowBorder,
        stickyHeader: stickyHeader,
        overflowMenuOnHover: overflowMenuOnHover
      };
    });

    _defineProperty(_assertThisInitialized(_this), "getTableContainerProps", function () {
      var _this$props2 = _this.props,
          stickyHeader = _this$props2.stickyHeader,
          useStaticWidth = _this$props2.useStaticWidth;
      return {
        stickyHeader: stickyHeader,
        useStaticWidth: useStaticWidth
      };
    });

    _defineProperty(_assertThisInitialized(_this), "getSelectedRows", function () {
      return _this.state.rowIds.filter(function (id) {
        var row = _this.state.rowsById[id];
        return row.isSelected && !row.disabled;
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getFilteredRowIds", function () {
      var filteredRowIds = typeof _this.state.filterInputValue === 'string' ? _this.props.filterRows({
        rowIds: _this.state.rowIds,
        headers: _this.props.headers,
        cellsById: _this.state.cellsById,
        inputValue: _this.state.filterInputValue,
        getCellId: getCellId
      }) : _this.state.rowIds;

      if (filteredRowIds.length == 0) {
        return [];
      }

      return filteredRowIds;
    });

    _defineProperty(_assertThisInitialized(_this), "getTablePrefix", function () {
      return "data-table-".concat(_this.instanceId);
    });

    _defineProperty(_assertThisInitialized(_this), "setAllSelectedState", function (initialState, isSelected, filteredRowIds) {
      var rowIds = initialState.rowIds;
      return {
        rowsById: rowIds.reduce(function (acc, id) {
          return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, id, _objectSpread(_objectSpread({}, initialState.rowsById[id]), !initialState.rowsById[id].disabled && {
            isSelected: filteredRowIds.includes(id) && isSelected
          })));
        }, {})
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnCancel", function () {
      _this.setState(function (state) {
        return _objectSpread({
          shouldShowBatchActions: false
        }, _this.setAllSelectedState(state, false, _this.getFilteredRowIds()));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleSelectAll", function () {
      _this.setState(function (state) {
        var filteredRowIds = _this.getFilteredRowIds();

        var rowsById = state.rowsById;
        var isSelected = !(Object.values(rowsById).filter(function (row) {
          return row.isSelected && !row.disabled;
        }).length > 0);
        return _objectSpread({
          shouldShowBatchActions: isSelected
        }, _this.setAllSelectedState(state, isSelected, filteredRowIds));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnSelectRow", function (rowId) {
      return function () {
        _this.setState(function (state) {
          var row = state.rowsById[rowId];

          if (_this.props.radio) {
            // deselect all radio buttons
            var rowsById = Object.entries(state.rowsById).reduce(function (p, c) {
              var _c = _slicedToArray(c, 2),
                  key = _c[0],
                  val = _c[1];

              val.isSelected = false;
              p[key] = val;
              return p;
            }, {});
            return {
              shouldShowBatchActions: false,
              rowsById: _objectSpread(_objectSpread({}, rowsById), {}, _defineProperty({}, rowId, _objectSpread(_objectSpread({}, row), {}, {
                isSelected: !row.isSelected
              })))
            };
          }

          var selectedRows = state.rowIds.filter(function (id) {
            return state.rowsById[id].isSelected;
          }).length; // Predict the length of the selected rows after this change occurs

          var selectedRowsCount = !row.isSelected ? selectedRows + 1 : selectedRows - 1;
          return {
            // Basic assumption here is that we want to show the batch action bar if
            // the row is being selected. If it's being unselected, then see if we
            // have a non-zero number of selected rows that batch actions could
            // still apply to
            shouldShowBatchActions: !row.isSelected || selectedRowsCount > 0,
            rowsById: _objectSpread(_objectSpread({}, state.rowsById), {}, _defineProperty({}, rowId, _objectSpread(_objectSpread({}, row), {}, {
              isSelected: !row.isSelected
            })))
          };
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnExpandRow", function (rowId) {
      return function () {
        _this.setState(function (state) {
          var row = state.rowsById[rowId];
          var isExpandedAll = state.isExpandedAll;
          return {
            isExpandedAll: row.isExpanded ? false : isExpandedAll,
            rowsById: _objectSpread(_objectSpread({}, state.rowsById), {}, _defineProperty({}, rowId, _objectSpread(_objectSpread({}, row), {}, {
              isExpanded: !row.isExpanded
            })))
          };
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnExpandAll", function () {
      _this.setState(function (state) {
        var rowIds = state.rowIds,
            isExpandedAll = state.isExpandedAll;
        return {
          isExpandedAll: !isExpandedAll,
          rowsById: rowIds.reduce(function (acc, id) {
            return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, id, _objectSpread(_objectSpread({}, state.rowsById[id]), {}, {
              isExpanded: !isExpandedAll
            })));
          }, {})
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleSortBy", function (headerKey) {
      return function () {
        _this.setState(function (state) {
          return getNextSortState(_this.props, state, {
            key: headerKey
          });
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnInputValueChange", function (event, defaultValue) {
      if (event.target) {
        _this.setState({
          filterInputValue: event.target.value
        });
      }

      if (defaultValue) {
        _this.setState({
          filterInputValue: defaultValue
        });
      }
    });

    _this.state = _objectSpread(_objectSpread({}, getDerivedStateFromProps(_props, {})), {}, {
      isExpandedAll: false // Start with collapsed state, treat `undefined` as neutral state

    });
    _this.instanceId = getInstanceId();
    return _this;
  }

  _createClass(DataTable, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this2 = this;

      if (prevProps === this.props) {
        return;
      }

      var prevRowIds = prevProps.rows.map(function (row) {
        return row.id;
      });
      var rowIds = this.props.rows.map(function (row) {
        return row.id;
      });

      if (!isEqual(prevRowIds, rowIds)) {
        this.setState(function (state) {
          return getDerivedStateFromProps(_this2.props, state);
        });
        return;
      }

      var prevHeaders = prevProps.headers.map(function (header) {
        return header.key;
      });
      var headers = this.props.headers.map(function (header) {
        return header.key;
      });

      if (!isEqual(prevHeaders, headers)) {
        this.setState(function (state) {
          return getDerivedStateFromProps(_this2.props, state);
        });
        return;
      }

      if (!isEqual(prevProps.rows, this.props.rows)) {
        this.setState(function (state) {
          return getDerivedStateFromProps(_this2.props, state);
        });
        return;
      }
    }
    /**
     * Get the props associated with the given header. Mostly used for adding in
     * sorting behavior.
     *
     * @param {object} config
     * @param {string} config.header the header we want the props for
     * @param {Function} config.onClick a custom click handler for the header
     * @param {boolean} config.isSortable
     * @returns {object}
     */

  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      // eslint-disable-next-line react/prop-types
      var _this$props3 = this.props,
          children = _this$props3.children,
          filterRows = _this$props3.filterRows,
          headers = _this$props3.headers,
          render = _this$props3.render;
      var _this$state3 = this.state,
          filterInputValue = _this$state3.filterInputValue,
          rowIds = _this$state3.rowIds,
          rowsById = _this$state3.rowsById,
          cellsById = _this$state3.cellsById;
      var filteredRowIds = typeof filterInputValue === 'string' ? filterRows({
        rowIds: rowIds,
        headers: headers,
        cellsById: cellsById,
        inputValue: filterInputValue,
        getCellId: getCellId
      }) : rowIds;
      var renderProps = {
        // Data derived from state
        rows: denormalize(filteredRowIds, rowsById, cellsById),
        headers: this.props.headers,
        selectedRows: denormalize(this.getSelectedRows(), rowsById, cellsById),
        // Prop accessors/getters
        getHeaderProps: this.getHeaderProps,
        getExpandHeaderProps: this.getExpandHeaderProps,
        getRowProps: this.getRowProps,
        getSelectionProps: this.getSelectionProps,
        getToolbarProps: this.getToolbarProps,
        getBatchActionProps: this.getBatchActionProps,
        getTableProps: this.getTableProps,
        getTableContainerProps: this.getTableContainerProps,
        // Custom event handlers
        onInputChange: this.handleOnInputValueChange,
        // Expose internal state change actions
        sortBy: function sortBy(headerKey) {
          return _this3.handleSortBy(headerKey)();
        },
        selectAll: this.handleSelectAll,
        selectRow: function selectRow(rowId) {
          return _this3.handleOnSelectRow(rowId)();
        },
        expandRow: function expandRow(rowId) {
          return _this3.handleOnExpandRow(rowId)();
        },
        expandAll: this.handleOnExpandAll,
        radio: this.props.radio
      };

      if (render !== undefined) {
        return render(renderProps);
      }

      if (children !== undefined) {
        return children(renderProps);
      }

      return null;
    }
  }]);

  return DataTable;
}(React.Component);

_defineProperty(DataTable, "propTypes", {
  /**
   * Optional hook to manually control filtering of the rows from the
   * TableToolbarSearch component
   */
  filterRows: PropTypes.func,

  /**
   * The `headers` prop represents the order in which the headers should
   * appear in the table. We expect an array of objects to be passed in, where
   * `key` is the name of the key in a row object, and `header` is the name of
   * the header.
   */
  headers: PropTypes.arrayOf(PropTypes.shape({
    key: PropTypes.string.isRequired,
    header: PropTypes.node.isRequired
  })).isRequired,

  /**
   * Specify whether the table should be able to be sorted by its headers
   */
  isSortable: PropTypes.bool,

  /**
   * Provide a string for the current locale
   */
  locale: PropTypes.string,

  /**
   * Specify whether the overflow menu (if it exists) should be shown always, or only on hover
   */
  overflowMenuOnHover: PropTypes.bool,

  /**
   * Specify whether the control should be a radio button or inline checkbox
   */
  radio: PropTypes.bool,

  /**
   * The `rows` prop is where you provide us with a list of all the rows that
   * you want to render in the table. The only hard requirement is that this
   * is an array of objects, and that each object has a unique `id` field
   * available on it.
   */
  rows: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string.isRequired,
    disabled: PropTypes.bool,
    isSelected: PropTypes.bool,
    isExpanded: PropTypes.bool
  })).isRequired,

  /**
   * `false` If true, will remove the table border
   */
  shouldShowBorder: PropTypes.bool,

  /**
   *  Change the row height of table. Currently supports `xs`, `sm`, `md`, `lg`, and `xl`.
   *  The previous terms (`compact`, `short`, `normal`, and `tall`) will be removed in the next major release.
   */
  size: PropTypes.oneOf(['compact', 'short', 'normal', 'tall', 'xs', 'sm', 'md', 'lg', 'xl']),

  /**
   * Optional hook to manually control sorting of the rows.
   */
  sortRow: PropTypes.func,

  /**
   * Specify whether the header should be sticky.
   * Still experimental: may not work with every combination of table props
   */
  stickyHeader: PropTypes.bool,

  /**
   * Optional method that takes in a message id and returns an
   * internationalized string. See `DataTable.translationKeys` for all
   * available message ids.
   */
  translateWithId: PropTypes.func,

  /**
   * `false` If true, will use a width of 'auto' instead of 100%
   */
  useStaticWidth: PropTypes.bool,

  /**
   * `true` to add useZebraStyles striping.
   */
  useZebraStyles: PropTypes.bool
});

_defineProperty(DataTable, "defaultProps", {
  sortRow: defaultSortRow,
  filterRows: defaultFilterRows,
  locale: 'en',
  size: 'normal',
  overflowMenuOnHover: true,
  translateWithId: translateWithId
});

_defineProperty(DataTable, "translationKeys", Object.values(translationKeys));

export { DataTable as default };