import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "searchContainerClass", "onChange", "onClear", "translateWithId", "placeHolderText", "placeholder", "labelText", "expanded", "defaultExpanded", "defaultValue", "disabled", "onExpand", "persistent", "persistant", "id", "onBlur", "onFocus"];

/**
 * Copyright IBM Corp. 2016, 2019
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useMemo, useRef, useState, useEffect } from 'react';
import { settings } from 'carbon-components';
import Search from '../Search';
import setupGetInstanceId from './tools/instanceId';
import deprecate from '../../prop-types/deprecate';
var prefix = settings.prefix;
var getInstanceId = setupGetInstanceId();
var translationKeys = {
  'carbon.table.toolbar.search.label': 'Filter table',
  'carbon.table.toolbar.search.placeholder': 'Filter table'
};

var translateWithId = function translateWithId(id) {
  return translationKeys[id];
};

var TableToolbarSearch = function TableToolbarSearch(_ref) {
  var _cx;

  var className = _ref.className,
      searchContainerClass = _ref.searchContainerClass,
      onChangeProp = _ref.onChange,
      onClear = _ref.onClear,
      t = _ref.translateWithId,
      placeHolderText = _ref.placeHolderText,
      placeholder = _ref.placeholder,
      labelText = _ref.labelText,
      expandedProp = _ref.expanded,
      defaultExpanded = _ref.defaultExpanded,
      defaultValue = _ref.defaultValue,
      disabled = _ref.disabled,
      onExpand = _ref.onExpand,
      persistent = _ref.persistent,
      persistant = _ref.persistant,
      id = _ref.id,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _useRef = useRef(expandedProp !== undefined),
      controlled = _useRef.current;

  var _useState = useState(defaultExpanded || defaultValue),
      _useState2 = _slicedToArray(_useState, 2),
      expandedState = _useState2[0],
      setExpandedState = _useState2[1];

  var expanded = controlled ? expandedProp : expandedState;

  var _useState3 = useState(defaultValue || ''),
      _useState4 = _slicedToArray(_useState3, 2),
      value = _useState4[0],
      setValue = _useState4[1];

  var uniqueId = useMemo(getInstanceId, []);

  var _useState5 = useState(null),
      _useState6 = _slicedToArray(_useState5, 2),
      focusTarget = _useState6[0],
      setFocusTarget = _useState6[1];

  useEffect(function () {
    if (focusTarget) {
      focusTarget.current.querySelector('input').focus();
      setFocusTarget(null);
    }
  }, [focusTarget]);
  useEffect(function () {
    if (defaultValue) {
      onChangeProp('', defaultValue);
    }
  }, //eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  var searchClasses = cx(className, (_cx = {}, _defineProperty(_cx, searchContainerClass, searchContainerClass), _defineProperty(_cx, "".concat(prefix, "--toolbar-search-container-active"), expanded), _defineProperty(_cx, "".concat(prefix, "--toolbar-search-container-disabled"), disabled), _defineProperty(_cx, "".concat(prefix, "--toolbar-search-container-expandable"), !persistent || !persistent && !persistant), _defineProperty(_cx, "".concat(prefix, "--toolbar-search-container-persistent"), persistent || persistant), _cx));

  var handleExpand = function handleExpand(event) {
    var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : !expanded;

    if (!disabled) {
      if (!controlled && (!persistent || !persistent && !persistant)) {
        setExpandedState(value);
      }

      if (onExpand) {
        onExpand(event, value);
      }
    }
  };

  var onChange = function onChange(e) {
    setValue(e.target.value);

    if (onChangeProp) {
      onChangeProp(e);
    }
  };

  var handleOnFocus = function handleOnFocus(event) {
    return handleExpand(event, true);
  };

  var handleOnBlur = function handleOnBlur(event) {
    return !value && handleExpand(event, false);
  };

  return /*#__PURE__*/React.createElement(Search, _extends({
    disabled: disabled,
    className: searchClasses,
    value: value,
    id: typeof id !== 'undefined' ? id : uniqueId.toString(),
    labelText: labelText || t('carbon.table.toolbar.search.label'),
    placeholder: placeHolderText || placeholder || t('carbon.table.toolbar.search.placeholder'),
    onChange: onChange,
    onClear: onClear,
    onFocus: onFocus ? function (event) {
      return onFocus(event, handleExpand);
    } : handleOnFocus,
    onBlur: onBlur ? function (event) {
      return onBlur(event, handleExpand);
    } : handleOnBlur
  }, rest));
};

TableToolbarSearch.propTypes = {
  children: PropTypes.node,

  /**
   * Provide an optional class name for the search container
   */
  className: PropTypes.string,

  /**
   * Specifies if the search should initially render in an expanded state
   */
  defaultExpanded: PropTypes.bool,

  /**
   * Provide an optional default value for the Search component
   */
  defaultValue: PropTypes.string,

  /**
   * Specifies if the search should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specifies if the search should expand
   */
  expanded: PropTypes.bool,

  /**
   * Provide an optional id for the search container
   */
  id: PropTypes.string,

  /**
   * Provide an optional label text for the Search component icon
   */
  labelText: PropTypes.string,

  /**
   * Provide an optional function to be called when the search input loses focus, this will be
   * passed the event as the first parameter and a function to handle the expanding of the search
   * input as the second
   */
  onBlur: PropTypes.func,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: PropTypes.func,

  /**
   * Optional callback called when the search value is cleared.
   */
  onClear: PropTypes.func,

  /**
   * Provide an optional hook that is called each time the input is expanded
   */
  onExpand: PropTypes.func,

  /**
   * Provide an optional function to be called when the search input gains focus, this will be
   * passed the event as the first parameter and a function to handle the expanding of the search
   * input as the second.
   */
  onFocus: PropTypes.func,
  persistant: deprecate(PropTypes.bool, "\nThe prop `persistant` for TableToolbarSearch has been deprecated in favor of `persistent`. Please use `persistent` instead."),

  /**
   * Whether the search should be allowed to expand
   */
  persistent: PropTypes.bool,

  /**
   * Deprecated in favor of `placeholder`
   */
  placeHolderText: deprecate(PropTypes.string, "\nThe prop `placeHolderText` for TableToolbarSearch has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

  /**
   * Provide an optional placeholder text for the Search component
   */
  placeholder: PropTypes.string,

  /**
   * Provide an optional className for the overall container of the Search
   */
  searchContainerClass: PropTypes.string,

  /**
   * Optional prop to specify the tabIndex of the <Search> (in expanded state) or the container (in collapsed state)
   */
  tabIndex: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

  /**
   * Provide custom text for the component for each translation id
   */
  translateWithId: PropTypes.func.isRequired
};
TableToolbarSearch.defaultProps = {
  tabIndex: '0',
  translateWithId: translateWithId,
  persistent: false,
  onClear: function onClear() {}
};
export default TableToolbarSearch;