import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import DataTable, { Table, TableBody, TableCell, TableContainer, TableHead, TableHeader, TableRow, TableSelectAll, TableSelectRow } from '../../DataTable';
import { rows, headers } from './shared';
import mdx from '../DataTable.mdx';
import { action } from '@storybook/addon-actions';
export default {
  title: 'Components/DataTable/Selection',
  component: DataTable,
  subcomponents: {
    TableSelectAll: TableSelectAll,
    TableSelectRow: TableSelectRow,
    Table: Table,
    TableBody: TableBody,
    TableCell: TableCell,
    TableContainer: TableContainer,
    TableHead: TableHead,
    TableHeader: TableHeader,
    TableRow: TableRow
  },
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var Usage = function Usage() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getSelectionProps = _ref.getSelectionProps,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With selection"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: i
      }, getRowProps({
        row: row
      }), {
        onClick: function onClick(evt) {
          action('TableRow onClick')(evt);
        }
      }), /*#__PURE__*/React.createElement(TableSelectRow, _extends({}, getSelectionProps({
        row: row
      }), {
        onSelect: function onSelect(evt) {
          action('TableSelectRow onSelect')(evt);
          getSelectionProps({
            row: row
          }).onSelect(evt);
        }
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};
export var WithRadioSelection = function WithRadioSelection() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers,
    radio: true
  }, function (_ref2) {
    var rows = _ref2.rows,
        headers = _ref2.headers,
        getHeaderProps = _ref2.getHeaderProps,
        getRowProps = _ref2.getRowProps,
        getSelectionProps = _ref2.getSelectionProps,
        getTableProps = _ref2.getTableProps,
        getTableContainerProps = _ref2.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With radio selection"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement("th", {
      scope: "col"
    }), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/React.createElement(TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};
export var WithSelectionAndSorting = function WithSelectionAndSorting() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers,
    isSortable: true
  }, function (_ref3) {
    var rows = _ref3.rows,
        headers = _ref3.headers,
        getHeaderProps = _ref3.getHeaderProps,
        getRowProps = _ref3.getRowProps,
        getSelectionProps = _ref3.getSelectionProps,
        getTableProps = _ref3.getTableProps,
        getTableContainerProps = _ref3.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With selection"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/React.createElement(TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};